#!/usr/bin/env python
#
# This file is part of REPA: Release Engineering Process Assistant.
#
# Copyright (C) 2013 Intel Corporation
#
# REPA is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.

"""
REPA: Release Engineering Process Assistant.

Copyright (C) Intel Corporation 2013
Licence: GPL version 2
Author: Ed Bartosh <eduard.bartosh@intel.com>

List module.
Get list of submissions.
"""

import sys
import json
from xml.etree import cElementTree as ET

from repa.common import get_project_by_name, RepaException
from repa.obs import OBS

from repa.main import sub_main

def set_update_reference_project(obs, prj, ref_target_prj=None):
    """ Set update reference for project """

    if ref_target_prj is None:
       raise RepaException("Update reference is not supported. ")

    meta = obs.get_meta(prj)
    # repalace link project 
    xml_meta = ET.fromstring(''.join(meta))
    for link_project in xml_meta.findall('link'):
        link_project.set('project', ref_target_prj)
    # replace repository path
    for repo_element in xml_meta.findall('repository'):
        for element in repo_element.findall('path'):
            element.set('project',ref_target_prj)
    # replace description
    description = json.loads(xml_meta.find('description').text)
    if description:
        description['ref_obs_target_prj'] = ref_target_prj
        xml_meta.find('description').text = json.dumps(description)
    obs.set_meta(ET.tostring(xml_meta), prj)

def update(obs, name, target, ref_target_prj):
    """update meta of information about submission"""
    prj, meta, build_results = get_project_by_name(obs, name, target)

    if meta['ref_obs_target_prj']:
        print 'old_ref: %s new_ref: %s' %(meta['ref_obs_target_prj'],
                                           ref_target_prj)
    else:
        raise RepaException("update is not supported. "
                                "ref_obs_target_prj values: %s" % \
                                (ref_target_prj))

    if not obs.exists(ref_target_prj):
        raise RepaException("update is not supported. "
                            "ref_target_prj %s is not exists" % \
                            (ref_target_prj))
    set_update_reference_project(obs, prj, ref_target_prj)

class Update(object):
    """Subcommand: Update meta of information about submission."""

    name = 'update'
    description = 'Update meta of Information about submission'
    help = description

    @staticmethod
    def add_arguments(parser, config):
        """
        Add arguments to the parser. Called from [sub_]main.
        Set defaults for arguments from config.
        """
        parser.add_argument('submission', help='submission or group')
        parser.add_argument('-r', '--refprj',
                            help='Update reference project in project')
    @staticmethod
    def run(argv):
        """Command line entry point. Called from [sub_]main"""
        obs = OBS(argv.apiurl, argv.apiuser, argv.apipasswd)
        return update(obs, argv.submission, argv.project, argv.refprj)


if __name__ == '__main__':
    sys.exit(sub_main(sys.argv[1:], Update()))
