#
# spec file for package qemu
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


# !! IMPORTANT !! See README.PACKAGING before modifying package in any way


%define _buildshell /bin/bash

%bcond_with system_membarrier

Name:           qemu-arm-static
URL:            https://www.qemu.org/
Summary:        CPU emulator for user space
License:        BSD-2-Clause AND BSD-3-Clause AND GPL-2.0-only AND GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT
Group:          System/Emulators/PC
Version:        4.2.1.tizen20240109
Release:        0
Source:         qemu-4.2.1.tar.bz2
# this is to make lint happy
Source300:      rpmlintrc
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

# Common BuildRequires listed here:
BuildRequires:  fdupes
BuildRequires:  gcc-c++
BuildRequires:  glib2-devel-static
BuildRequires:  glibc-devel-static
BuildRequires:  makeinfo
BuildRequires:  ninja
BuildRequires:  pcre-devel-static
BuildRequires:  python2-base >= 2.7
BuildRequires:  zlib-devel-static

Provides:       qemu:%_bindir/qemu-arm-static
Provides:       tizen-qemu-arm-static = 2024.01.09

%description
QEMU provides CPU emulation along with other related capabilities. This package
provides programs to run user space binaries and libraries meant for another
architecture. The syscall interface is intercepted and execution below the
syscall layer occurs on the native hardware and operating system.

%prep
%setup -q -n qemu-4.2.1

%build


%define srcdir %{_builddir}/%buildsubdir
%define blddir %srcdir/build
mkdir -p %blddir
cd %blddir

%srcdir/configure \
	--prefix=%_prefix \
	--sysconfdir=%_sysconfdir \
	--libdir=%_libdir \
	--libexecdir=%_libexecdir \
	--localstatedir=%_localstatedir \
	--docdir=%_docdir \
	--firmwarepath=%_datadir/%name \
	--python=%_bindir/python2.7 \
	--extra-cflags="%{optflags}" \
	--target-list="arm-linux-user,aarch64-linux-user,riscv32-linux-user,riscv64-linux-user" \
	--without-default-devices \
	--disable-system \
	--enable-linux-user \
	--disable-tools \
	--disable-guest-agent \
	--static \
	--disable-modules \
	--disable-pie \
	--disable-docs \
	--audio-drv-list="" \
	--disable-blobs \
	--disable-bochs \
	--disable-capstone \
	--disable-cloop \
	--enable-coroutine-pool \
	--disable-dmg \
	--disable-fdt \
	--disable-iconv \
	--disable-kvm \
	--disable-libdaxctl \
	--disable-linux-io-uring \
	--disable-malloc-trim \
%if %{with system_membarrier}
	--enable-membarrier \
%else
	--disable-membarrier \
%endif
	--disable-parallels \
	--disable-plugins \
	--disable-qcow1 \
	--disable-qed \
	--disable-replication \
	--disable-sheepdog \
	--disable-slirp \
	--disable-tpm \
	--disable-vdi \
	--disable-vhost-crypto \
	--disable-vhost-kernel \
	--disable-vhost-net \
	--disable-vhost-scsi \
	--disable-vhost-user \
	--disable-vhost-user-fs \
	--disable-vhost-vsock \
	--disable-vnc \
	--disable-vvfat \
	--disable-xkbcommon

make %{?_smp_mflags} V=1

%install
cd %blddir

make %{?_smp_mflags} install DESTDIR=%{buildroot}
rm -rf %{buildroot}%_datadir/qemu/keymaps
unlink %{buildroot}%_datadir/qemu/trace-events-all
install -d -m 755 %{buildroot}%_sbindir
install -m 755 scripts/qemu-binfmt-conf.sh %{buildroot}%_sbindir

mv %{buildroot}%_bindir/qemu-binfmt %{buildroot}%_bindir/qemu-arm-binfmt
ln -s qemu-arm-binfmt %{buildroot}%_bindir/qemu-arm64-binfmt
ln -s qemu-arm-binfmt %{buildroot}%_bindir/qemu-riscv32-binfmt
ln -s qemu-arm-binfmt %{buildroot}%_bindir/qemu-riscv64-binfmt

mv %{buildroot}%_bindir/qemu-arm %{buildroot}%_bindir/qemu-arm-static
mv %{buildroot}%_bindir/qemu-aarch64 %{buildroot}%_bindir/qemu-arm64-static
mv %{buildroot}%_bindir/qemu-riscv32 %{buildroot}%_bindir/qemu-riscv32-static
mv %{buildroot}%_bindir/qemu-riscv64 %{buildroot}%_bindir/qemu-riscv64-static

%fdupes -s %{buildroot}

%clean
rm -rf %{buildroot}

%files
%defattr(-, root, root)
%_bindir/qemu-*-binfmt
%_bindir/qemu-*-static
%_sbindir/qemu-binfmt-conf.sh

%changelog
* Wed Jun 17 2020 yan11.meng@samsung.com
- Fix deb upload failed issue on launchpad
- change struct ucontext to ucontext_t
- use ucontext_t instead struct ucontext.
- fix pylint errors for qemu-arm-static
- fix build error in xUbuntu_19.10
- fix build error for ubuntu20.04

* Sat Dec 31 2016 sk7.park@samsung.com
- Add depands packae qemu
- Add the qemu-arm-binfmt (qemu-arm64-binfmt)
- Upgrade tizen version to tizen20161231
* Thu Oct 02 2014 markus.lehtonen@linux.intel.com
- Change packaging to Debian non-native
* Wed Jul 09 2014 gui.chen@intel.com
- update to v1.6.0
