/*
 * libthor - Tizen Thor communication protocol
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef THOR_INTERNAL_H__
#define THOR_INTERNAL_H__

#include <libusb-1.0/libusb.h>

#include "thor.h"
#include "thor-proto.h"

#define DEFAULT_TIMEOUT 4000 /* 4000 ms */

#ifndef offsetof
#define offsetof(type, member) ((size_t) &((type *)0)->member)
#endif /* offsetof */

#define container_of(ptr, type, member) ({                      \
        const typeof( ((type *)0)->member ) *__mptr = (ptr);    \
        (type *)( (char *)__mptr - offsetof(type,member) );})

#define ARRAY_SIZE(_a) (sizeof(_a)/sizeof(_a[0]))

struct thor_transport_ops {
	int (*open)(thor_device_handle *th, struct thor_device_id *dev_id,
		    int wait);
	void (*close)(thor_device_handle *th);
	int (*send)(thor_device_handle *th, unsigned char *buf,
		    off_t count, int timeout);
	int (*recv)(thor_device_handle *th, unsigned char *buf,
		    off_t count, int timeout);
	int (*send_data)(thor_device_handle *th,
			 struct thor_data_src *data,
			 off_t trans_unit_size,
			 thor_progress_cb report_progress,
			 void *user_data);
};

struct thor_device_handle {
	enum thor_transport_type type;
	struct thor_transport_ops *ops;
	void *dev_priv;
};

int t_file_get_data_src(const char *path, struct thor_data_src **data);

int t_tar_get_data_src(const char *path, struct thor_data_src **data);

#endif /* THOR_INTERNAL_H__ */

