/*
 * libthor - Tizen Thor communication protocol
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef THOR_TRNASPORT_H__
#define THOR_TRANSPORT_H__

#include "thor.h"
#include "thor_internal.h"

int t_thor_init(thor_device_handle *th);
void t_thor_cleanup(thor_device_handle *th);
int t_thor_open(thor_device_handle *th, struct thor_device_id *dev_id,
		int wait);
void t_thor_close(thor_device_handle *th);
int t_thor_send_raw_data(thor_device_handle *th,
			 struct thor_data_src *data,
			 off_t trans_unit_size,
			 thor_progress_cb report_progress,
			 void *user_data);
int t_thor_send(thor_device_handle *th, unsigned char *buf,
		off_t count, int timeout);
int t_thor_recv(thor_device_handle *th, unsigned char *buf,
		off_t count, int timeout);

/* USB transport */
struct usb_device_handle {
	libusb_device_handle *devh;
	int control_interface;
	int control_interface_id;
	int data_interface;
	int data_interface_id;
	int data_ep_in;
	int data_ep_out;
};

int thor_usb_init(thor_device_handle *th);
void thor_usb_cleanup(thor_device_handle *th);
int t_acm_prepare_device(struct usb_device_handle *uh);

/* Net transport */
struct net_device_handle {
	int sock_fd;
};

int thor_net_init(thor_device_handle *th);
void thor_net_cleanup(thor_device_handle *th);

#endif /* THOR_TRANSPORT_H__ */
