/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.memoryprofiler;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class MemoryProfilerPane
extends ECPPopupPane
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(MemoryProfilerPane.class).getLogger();
    private boolean isInitialize = false;
    private STATUS_E m_status = STATUS_E.NONE;
    @FXML
    private Button fxLaunchBtn;
    @FXML
    private Label fxStatusLabel;
    @FXML
    private Label fxAppIdLabel;
    @FXML
    private Label fxCurrentRamUsageLabel;
    @FXML
    private Label fxMaxRamUsageLabel;

    public Pane create() {
        VBox vBox;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("MemoryProfiler.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            vBox = (VBox)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new Pane();
        }
        return vBox;
    }

    private void CommonEventProcPB(GeneratedMessage generatedMessage, int ... nArray) {
        if (!this.isInitialize) {
            return;
        }
        logger.info("event proc pb ");
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            logger.info("group : " + injectorNtf.getGroup());
            if (210 == injectorNtf.getGroup()) {
                int n = injectorNtf.getAction();
                logger.info("MemoryProfileer NTF action: " + n);
                String string = new String(injectorNtf.getData().toByteArray());
                logger.info("data:   " + string);
                string = string.trim();
                if (string == null || string.isEmpty()) {
                    logger.severe("data is empty.");
                    return;
                }
                for (int n2 : nArray) {
                    if (n == 253) {
                        this.processSetCurrentStatus(string);
                        return;
                    }
                    if (n != 254) continue;
                    this.fxLaunchBtn.setDisable(false);
                    return;
                }
            }
        }
    }

    private void processSetCurrentStatus(String string) {
        String[] stringArray = string.split("&!:");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("&!;");
            if (stringArray2.length != 4) {
                this.fxLaunchBtn.setDisable(false);
                return;
            }
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            String string5 = stringArray2[3];
            this.setMemoryProfilerStatus(string2, string3, string4, string5);
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        this.CommonEventProcPB(generatedMessage, 210);
    }

    private void setPaneData(String string, boolean bl, String string2) {
        this.setPaneData(string, bl, string2, " ", " ", " ");
    }

    private void setPaneData(String string, boolean bl, String string2, String string3, String string4, String string5) {
        this.fxStatusLabel.setText(string);
        this.fxLaunchBtn.setDisable(bl);
        this.fxLaunchBtn.setText(string2);
        this.fxAppIdLabel.setText(string3);
        this.fxCurrentRamUsageLabel.setText(string4);
        this.fxMaxRamUsageLabel.setText(string5);
    }

    private void setMemoryProfilerStatus(String string, String string2, String string3, String string4) {
        if (string.equals("1")) {
            this.m_status = STATUS_E.STOPPED;
            this.setPaneData("Stopped", false, "Start");
        } else if (string.equals("0")) {
            this.m_status = STATUS_E.RUNNING;
            this.setPaneData("Running", false, "Stop", string2, string3, string4);
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.isInitialize = true;
        EventMgr.getInstance().AddLsn("mempro", (ILsn)this);
        this.sendMemoryProfilerMessage(210, 253);
    }

    private void sendMemoryProfilerMessage(int n, int n2) {
        this.sendMemoryProfilerMessage(n, n2, "");
    }

    private void sendMemoryProfilerMessage(int n, int n2, String string) {
        MessageSender.getInstance().sendInjectorReq("mempro", n, n2, string);
    }

    @FXML
    public void onClickLaunchBtn(ActionEvent actionEvent) {
        switch (this.m_status) {
            case BROKEN: 
            case STOPPED: {
                this.fxLaunchBtn.setDisable(true);
                this.sendMemoryProfilerMessage(210, 251);
                break;
            }
            case RUNNING: {
                this.fxLaunchBtn.setDisable(true);
                this.sendMemoryProfilerMessage(210, 252);
                break;
            }
        }
    }

    private static enum STATUS_E {
        NONE,
        STOPPED,
        RUNNING,
        LAUNCHNG,
        STOPPING,
        BROKEN;

    }
}

