/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.network;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;

public class NetworkPortForwardCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(NetworkPortForwardCLI.class).getLogger();
    @Argument(index=0, required=true)
    String networkType;
    @Argument(index=1, required=true)
    String sourcePort;
    @Argument(index=2, required=true)
    String destPort;

    public NetworkPortForwardCLI() {
        this.messageType = "Network";
    }

    public int execute() {
        logger.info("networkType = " + this.networkType + ", sourcePort = " + this.sourcePort + ", destPort = " + this.destPort);
        if (!this.checkPort(this.sourcePort) || !this.checkPort(this.destPort)) {
            OutputUtil.printHelpError((String)DeviceMessages.getString("NetworkPortForwardCLI.0"), (String)this.help);
            return 25;
        }
        EventMgr.getInstance().AddLsnSet("Network");
        EventMgr.getInstance().AddLsn("Network", (ILsn)this);
        String string = this.networkType + ":" + this.sourcePort + ":10.0.2.15:" + this.destPort;
        MessageSender.getInstance().sendDeviceReq("Network", 0, 0, string);
        return 0;
    }

    private boolean checkPort(String string) {
        return !string.equals("") && string.matches("(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3})");
    }

    private void send() {
        MessageSender.getInstance().sendMonitorReq(this.createNetworkConnectMsg("get_link virtio-net-pci.0"));
        MessageSender.getInstance().sendMonitorReq(this.createNetworkMsg());
        MessageSender.getInstance().sendDeviceEcsReq("Network", 0, 123);
    }

    private String createNetworkConnectMsg(String string) {
        String string2 = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)string), (String)"Network");
        logger.info("msg = " + string2);
        return string2;
    }

    private String createNetworkMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"Network"), (String)"Network");
        logger.info("msg = " + string);
        return string;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        int n = -1;
        int n2 = -1;
        Ecs.InjectorNtf injectorNtf = null;
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            n = injectorNtf.getAction();
            n2 = injectorNtf.getGroup();
            if (123 == n) {
                logger.info("OnEventProcPB. action: " + n + " ,group: " + n2);
            }
        } else {
            return;
        }
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"return");
        logger.info("message = " + string2);
        if (string2.startsWith("hub")) {
            String string3 = this.getDestAddr(string2);
            String string4 = this.networkType + ":" + this.sourcePort + ":" + string3 + ":" + this.destPort;
            MessageSender.getInstance().sendDeviceReq("Network", 0, 0, string4);
            this.stopRunning();
        } else if (string2.trim().equals("on")) {
            logger.info("Link Status: on");
        } else if (string2.trim().equals("off")) {
            logger.info("Link Status: off");
        }
    }

    private String getDestAddr(String string) {
        String[] stringArray = string.split("\r\n");
        String string2 = null;
        String string3 = "";
        for (String string4 : stringArray) {
            if (string4.length() < 72) continue;
            if (string4.startsWith("VLAN")) {
                string2 = string4.substring(0, string4.length() - 1);
                continue;
            }
            if ((string4 = string4.substring(2, string4.length())).startsWith("Protocol[State]")) continue;
            string3 = string4.substring(44, 60).trim();
        }
        return string3;
    }
}

