/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rotator;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class RotatorPane
extends ECPPopupPane
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(RotatorPane.class).getLogger();
    private boolean isInitialize = false;
    private static VBox vBoxPane;
    @FXML
    private Button fxRotateBtn;
    @FXML
    private Label fxStatusLabel;
    @FXML
    private Label fxDegreeLabel;

    public Pane create() {
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("rotator.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            vBoxPane = (VBox)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new Pane();
        }
        return vBoxPane;
    }

    private void CommonEventProcPB(GeneratedMessage generatedMessage, int ... nArray) {
        if (!this.isInitialize) {
            return;
        }
        logger.info("event proc pb ");
        if (generatedMessage instanceof Ecs.DeviceNtf) {
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            logger.info("group : " + deviceNtf.getGroup());
            if (250 == deviceNtf.getGroup()) {
                int n = deviceNtf.getAction();
                logger.info("Rotator NTF action: " + n);
                String string = new String(deviceNtf.getData().toByteArray());
                logger.info("data:   " + string);
                string = string.trim();
                if (string == null || string.isEmpty()) {
                    logger.severe("data is empty.");
                    return;
                }
                for (int n2 : nArray) {
                    if (n != 253) continue;
                    this.setRotatorStatus(string);
                    return;
                }
            }
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        this.CommonEventProcPB(generatedMessage, 253);
    }

    private void setRotatorStatus(String string) {
        if (string.equals("100")) {
            vBoxPane.getChildren().clear();
            Label label = new Label("Rotator is not supportted in 3840*1080 mode.");
            vBoxPane.getChildren().add((Object)label);
            vBoxPane.setAlignment(Pos.CENTER);
        } else if (string.equals("0")) {
            this.fxStatusLabel.setText("Landscape");
            this.fxDegreeLabel.setText("0");
        } else if (string.equals("1")) {
            this.fxStatusLabel.setText("Portrait");
            this.fxDegreeLabel.setText("270");
        } else if (string.equals("2")) {
            this.fxStatusLabel.setText("Landscape Reverse");
            this.fxDegreeLabel.setText("180");
        } else if (string.equals("3")) {
            this.fxStatusLabel.setText("Portrait Reverse");
            this.fxDegreeLabel.setText("90");
        } else if (string.equals("99")) {
            this.fxStatusLabel.setText("Rotating..");
            this.fxDegreeLabel.setText(" ");
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.isInitialize = true;
        EventMgr.getInstance().AddLsn("rotator", (ILsn)this);
        this.sendRotatorMessage(250, 253);
    }

    private void sendRotatorMessage(int n, int n2) {
        this.sendRotatorMessage(n, n2, "");
    }

    private void sendRotatorMessage(int n, int n2, String string) {
        MessageSender.getInstance().sendDeviceReq("rotator", n, n2, string);
    }

    @FXML
    public void onClickRotateBtn(ActionEvent actionEvent) {
        this.sendRotatorMessage(250, 251);
        this.sendRotatorMessage(250, 252);
    }
}

