/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.util.Arrays;
import java.util.logging.Logger;
import org.tizen.ecp.tuner.TunerPane;
import org.tizen.ecp.utils.LogUtil;

public class TunerChannelList {
    private static Logger logger = LogUtil.getECPLogger(TunerPane.class).getLogger();
    public static final String[] CH_NAMES = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", "107", "108", "109", "110", "111", "112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "124", "125", "126", "127", "128", "129", "130", "131", "132", "133", "134", "135", "136", "137", "138", "139", "140", "141", "142", "143", "144", "145", "146", "147", "148", "149", "150", "151", "152", "153", "154", "155", "156", "157", "158", "159"};
    private boolean[] is_occupied = new boolean[158];
    private int available_num = 158;
    private boolean is_changed = false;

    public TunerChannelList() {
        Arrays.fill(this.is_occupied, false);
    }

    private boolean check(int n) {
        return this.is_occupied[n];
    }

    private void toggleState() {
        this.is_changed = !this.is_changed;
    }

    public void ptcAdd(String string) {
        for (int i = 0; i < 158; ++i) {
            if (!string.equalsIgnoreCase(CH_NAMES[i])) continue;
            if (this.is_occupied[i]) break;
            this.is_occupied[i] = true;
            --this.available_num;
            this.is_changed = true;
            break;
        }
    }

    public void ptcRemove(String string) {
        for (int i = 0; i < 158; ++i) {
            if (!string.equalsIgnoreCase(CH_NAMES[i])) continue;
            if (!this.is_occupied[i]) break;
            this.is_occupied[i] = false;
            ++this.available_num;
            this.is_changed = true;
            break;
        }
    }

    public String[] getAvailableChannels() {
        String[] stringArray = new String[this.available_num];
        int n = 0;
        for (int i = 0; i < 158; ++i) {
            if (this.check(i)) continue;
            stringArray[n] = CH_NAMES[i];
            ++n;
        }
        this.is_changed = false;
        return stringArray;
    }

    public int getChannelNumberIndex(String string) {
        int n;
        String[] stringArray;
        if (this.is_changed) {
            stringArray = this.getAvailableChannels();
            this.toggleState();
        } else {
            stringArray = this.getAvailableChannels();
        }
        for (n = 0; n < this.available_num; ++n) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            logger.info("ptc " + string + "'s index is " + n);
            break;
        }
        return n;
    }

    public void initChannelList() {
        Arrays.fill(this.is_occupied, false);
        this.available_num = 158;
        this.is_changed = false;
    }

    public int getAvailableNumber() {
        return this.available_num;
    }

    public boolean isChanged() {
        return this.is_changed;
    }
}

