/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.appserver;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import javafx.scene.layout.Pane;
import org.tizen.ecp.appserver.AppServerModel;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class AppServerPane
extends ECPPopupPane {
    private AppServerModel model = new AppServerModel();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("AppServer", (ILsn)this);
        this.sendStatusRequest();
    }

    public void sendStatusRequest() {
        MessageSender.getInstance().sendInjectorReq("AppServer", 15, 124);
    }

    public void onShow() {
        int n = this.model.getStatus().get();
        if (n == 0) {
            this.model.getOperating().setSelected(true);
        } else if (n == 1) {
            this.model.getDevelopment().setSelected(true);
        } else if (n == 2) {
            this.model.getDeveloping().setSelected(true);
        } else {
            this.model.getOperating().setSelected(true);
        }
    }

    public Pane create() {
        Pane pane = null;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/appserver/AppServer.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[]{this.model});
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return pane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 124 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction()) {
            String string = injectorNtf.getData().toStringUtf8();
            if (string.startsWith(Integer.toString(0))) {
                this.model.setStatus(0);
                this.setCardDescription("Operating");
            } else if (string.startsWith(Integer.toString(1))) {
                this.model.setStatus(1);
                this.setCardDescription("Development");
            } else if (string.startsWith(Integer.toString(2))) {
                this.model.setStatus(2);
                this.setCardDescription("Developing");
            }
        }
    }
}

