/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.memoryprofiler;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class MemoryProfilerStartCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(MemoryProfilerStartCLI.class).getLogger();
    public static boolean isGetMemoryProfilerStarted = false;
    public static boolean running = false;

    private void sendMemoryProfilerMessage(int n, int n2) {
        this.sendMemoryProfilerMessage(n, n2, "");
    }

    private void sendMemoryProfilerMessage(int n, int n2, String string) {
        MessageSender.getInstance().sendInjectorReq("mempro", n, n2, string);
    }

    private void CommonEventProcPB(GeneratedMessage generatedMessage, int ... nArray) {
        if (!isGetMemoryProfilerStarted) {
            return;
        }
        logger.info("event proc pb ");
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            logger.info("group : " + injectorNtf.getGroup());
            if (210 == injectorNtf.getGroup()) {
                int n = injectorNtf.getAction();
                logger.info("MemoryProfileer NTF action: " + n);
                String string = new String(injectorNtf.getData().toByteArray());
                logger.info("data:   " + string);
                string = string.trim();
                if (string == null || string.isEmpty()) {
                    logger.severe("data is empty.");
                    return;
                }
                for (int n2 : nArray) {
                    if (n == 253) {
                        this.processSetCurrentStatus(string);
                        return;
                    }
                    if (n != 254) continue;
                    return;
                }
            }
        }
    }

    private void processSetCurrentStatus(String string) {
        String[] stringArray = string.split("&!:");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("&!;");
            if (stringArray2.length != 4) {
                return;
            }
            this.PrintResult(stringArray2);
            if (!stringArray2[0].equals("1")) continue;
            running = false;
        }
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        this.CommonEventProcPB(generatedMessage, 210);
    }

    private void StartGetMemoryProfiler() {
        if (isGetMemoryProfilerStarted) {
            return;
        }
        EventMgr.getInstance().AddLsn("mempro", (ILsn)this);
        this.sendMemoryProfilerMessage(210, 251);
        this.sendMemoryProfilerMessage(210, 253);
        isGetMemoryProfilerStarted = true;
    }

    private void PrintResult(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        System.out.printf("%s\n", "---------------------------------------------------");
        if (string.equals("1")) {
            System.out.printf("Status: %s\n", "STOPPED");
        } else if (string.equals("0")) {
            System.out.printf("Status: %s\n", "RUNNING");
        }
        System.out.printf("RunningAppID: %s\n", string2);
        System.out.printf("CurrentRamUsage: %s\n", string3);
        System.out.printf("MaxRamUsage: %s\n", string4);
        System.out.printf("%s\n", "---------------------------------------------------");
    }

    public int execute() {
        this.StartGetMemoryProfiler();
        running = true;
        while (running) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                System.out.printf("Memory profiler stop", new Object[0]);
            }
        }
        return 0;
    }
}

