/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.menu;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.ecp.control.ButtonToggleEvent;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.control.TizenToggleButton;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class MenuPane
extends ECPPopupPane
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(MenuPane.class).getLogger();
    private boolean isInitialize = false;
    Map<String, setCurrentStatus> statusSettingMethodMap = new HashMap<String, setCurrentStatus>();
    @FXML
    private GridPane fxClockGridPane;
    @FXML
    private GridPane fxRestGridPane;
    private TizenRadioButton AutoBtn;
    private TizenRadioButton ManualBtn;
    @FXML
    private ComboBox<String> fxDateMonth;
    @FXML
    private ComboBox<String> fxDateDay;
    @FXML
    private ComboBox<String> fxDateYear;
    @FXML
    private ComboBox<String> fxClockHour;
    @FXML
    private ComboBox<String> fxClockMinute;
    @FXML
    private ComboBox<String> fxClockAM;
    private List<ComboBox<String>> ClockComboBoxList = new ArrayList<ComboBox<String>>();
    @FXML
    private Button fxClApplyBtn;
    @FXML
    private ComboBox<String> fxLanComboBox;
    @FXML
    private Button fxDeviceNameApplyBtn;
    @FXML
    private TextField fxDeviceName;
    @FXML
    private HBox fxTtsModeToggle;
    private TizenToggleButton TtsModeBtn;
    @FXML
    private HBox fxCaptionModeToggle;
    private TizenToggleButton CaptionModeBtn;
    ChangeListener<Toggle> toggleChangeListener = new ChangeListener<Toggle>(){

        public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
        }
    };

    public Pane create() {
        VBox vBox;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("menu.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            vBox = (VBox)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new Pane();
        }
        return vBox;
    }

    private void processSetCurrentStatus(String string) {
        String[] stringArray = string.split("&!:");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("&!;");
            this.statusSettingMethodMap.get(stringArray2[0]).setStatus(stringArray[i]);
        }
    }

    private void CommonEventProcPB(GeneratedMessage generatedMessage, int ... nArray) {
        if (!this.isInitialize) {
            return;
        }
        logger.info("event proc pb ");
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            logger.info("group : " + injectorNtf.getGroup());
            if (15 == injectorNtf.getGroup()) {
                int n = injectorNtf.getAction();
                logger.info("Menu NTF action: " + n);
                String string = new String(injectorNtf.getData().toByteArray());
                logger.info("data:   " + string);
                string = string.trim();
                if (string == null || string.isEmpty()) {
                    logger.severe("data is empty.");
                    return;
                }
                for (int n2 : nArray) {
                    if (n != n2) continue;
                    this.processSetCurrentStatus(string);
                }
            }
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        this.CommonEventProcPB(generatedMessage, 230);
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
    }

    private void setComboItems(int n, int n2, ComboBox<String> comboBox) {
        Object[] objectArray = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Integer.toString(i + n2);
        }
        ObservableList observableList = FXCollections.observableArrayList((Object[])objectArray);
        comboBox.setItems(observableList);
    }

    private Boolean isLeapYear(int n) {
        Boolean bl = false;
        bl = n % 400 == 0 ? Boolean.valueOf(true) : (n % 100 == 0 ? Boolean.valueOf(false) : (n % 4 == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)));
        return bl;
    }

    private Boolean is_Clock_ComboBox_Contain_Right_Value() {
        for (ComboBox<String> comboBox : this.ClockComboBoxList) {
            if (comboBox.getItems().contains(comboBox.getValue())) continue;
            return false;
        }
        return true;
    }

    private void check_and_activate_clock_apply_button() {
        if (this.AutoBtn.isSelected()) {
            this.fxClApplyBtn.setDisable(false);
        } else if (this.ManualBtn.isSelected()) {
            if (this.is_Clock_ComboBox_Contain_Right_Value().booleanValue()) {
                this.fxClApplyBtn.setDisable(false);
            } else {
                this.fxClApplyBtn.setDisable(true);
            }
        } else {
            this.fxClApplyBtn.setDisable(true);
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.selectedToggleProperty().addListener(this.toggleChangeListener);
        this.AutoBtn = new TizenRadioButton("auto");
        this.AutoBtn.setToggleGroup(toggleGroup);
        this.fxClockGridPane.add((Node)this.AutoBtn, 0, 0);
        this.ManualBtn = new TizenRadioButton("manual");
        this.ManualBtn.setToggleGroup(toggleGroup);
        this.fxClockGridPane.add((Node)this.ManualBtn, 1, 0);
        this.ClockComboBoxList.add(this.fxDateMonth);
        this.ClockComboBoxList.add(this.fxDateDay);
        this.ClockComboBoxList.add(this.fxDateYear);
        this.ClockComboBoxList.add(this.fxClockHour);
        this.ClockComboBoxList.add(this.fxClockMinute);
        this.ClockComboBoxList.add(this.fxClockAM);
        toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                Boolean bl = false;
                if (MenuPane.this.AutoBtn.isSelected()) {
                    bl = false;
                } else if (MenuPane.this.ManualBtn.isSelected()) {
                    bl = true;
                }
                for (ComboBox comboBox : MenuPane.this.ClockComboBoxList) {
                    comboBox.setDisable(bl == false);
                }
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.setComboItems(12, 1, this.fxDateMonth);
        this.setComboItems(99, 2001, this.fxDateYear);
        this.setComboItems(12, 1, this.fxClockHour);
        this.setComboItems(60, 0, this.fxClockMinute);
        this.fxDateMonth.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                int n;
                try {
                    n = Integer.parseInt((String)MenuPane.this.fxDateYear.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                int[] nArray = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
                if (n != -1 && MenuPane.this.isLeapYear(n).booleanValue()) {
                    nArray[2] = 29;
                }
                try {
                    if (nArray[Integer.parseInt(string2)] < Integer.parseInt((String)MenuPane.this.fxDateDay.getValue())) {
                        MenuPane.this.fxDateDay.getSelectionModel().select((Object)"1");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    MenuPane.this.setComboItems(nArray[Integer.parseInt((String)MenuPane.this.fxDateMonth.getValue())], 1, (ComboBox<String>)MenuPane.this.fxDateDay);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxDateDay.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxDateYear.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                block7: {
                    try {
                        if (MenuPane.this.isLeapYear(Integer.parseInt(string2)).booleanValue() && ((String)MenuPane.this.fxDateMonth.getValue()).equals("2")) {
                            MenuPane.this.setComboItems(29, 1, (ComboBox<String>)MenuPane.this.fxDateDay);
                        } else if (((String)MenuPane.this.fxDateMonth.getValue()).equals("2")) {
                            if (MenuPane.this.isLeapYear(Integer.parseInt(string)).booleanValue() && ((String)MenuPane.this.fxDateDay.getValue()).equals("29")) {
                                MenuPane.this.fxDateMonth.getSelectionModel().select((Object)"3");
                                MenuPane.this.fxDateDay.getSelectionModel().select((Object)"1");
                            } else {
                                MenuPane.this.setComboItems(28, 1, (ComboBox<String>)MenuPane.this.fxDateDay);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!((String)MenuPane.this.fxDateMonth.getValue()).equals("2")) break block7;
                        MenuPane.this.setComboItems(28, 1, (ComboBox<String>)MenuPane.this.fxDateDay);
                    }
                }
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxClockHour.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxClockMinute.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxClockAM.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                MenuPane.this.check_and_activate_clock_apply_button();
            }
        });
        this.fxDeviceName.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (number2.intValue() > number.intValue() && MenuPane.this.fxDeviceName.getText().length() >= 30) {
                    MenuPane.this.fxDeviceName.setText(MenuPane.this.fxDeviceName.getText().substring(0, 30));
                }
                if (number2.intValue() == 0) {
                    MenuPane.this.fxDeviceNameApplyBtn.setDisable(true);
                } else {
                    MenuPane.this.fxDeviceNameApplyBtn.setDisable(false);
                }
            }
        });
        this.CaptionModeBtn = new TizenToggleButton("On", "Off");
        this.CaptionModeBtn.setOn(true);
        this.fxCaptionModeToggle.getChildren().add((Object)this.CaptionModeBtn);
        this.CaptionModeBtn.setOnSelected((EventHandler)new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent buttonToggleEvent) {
                if (MenuPane.this.CaptionModeBtn.getOn()) {
                    MenuPane.this.sendMenuMessage(240, 234, "On");
                } else {
                    MenuPane.this.sendMenuMessage(240, 234, "Off");
                }
            }
        });
        this.TtsModeBtn = new TizenToggleButton("On", "Off");
        this.TtsModeBtn.setOn(true);
        this.fxTtsModeToggle.getChildren().add((Object)this.TtsModeBtn);
        this.TtsModeBtn.setOnSelected((EventHandler)new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent buttonToggleEvent) {
                if (MenuPane.this.TtsModeBtn.getOn()) {
                    MenuPane.this.sendMenuMessage(240, 236, "On");
                } else {
                    MenuPane.this.sendMenuMessage(240, 236, "Off");
                }
            }
        });
        this.statusSettingMethodMap.put("CAPTION_MODE", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    if (stringArray[3].equals("On")) {
                        MenuPane.this.CaptionModeBtn.setOn(true);
                    } else if (stringArray[3].equals("Off")) {
                        MenuPane.this.CaptionModeBtn.setOn(false);
                    }
                }
            }
        });
        this.statusSettingMethodMap.put("TTS_MODE", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    if (stringArray[3].equals("On")) {
                        MenuPane.this.TtsModeBtn.setOn(true);
                    } else if (stringArray[3].equals("Off")) {
                        MenuPane.this.TtsModeBtn.setOn(false);
                    }
                }
            }
        });
        this.statusSettingMethodMap.put("DEVICE_NAME", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    MenuPane.this.fxDeviceName.setText(stringArray[3]);
                }
            }
        });
        this.statusSettingMethodMap.put("LANGUAGE_LIST", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    int n = Integer.parseInt(stringArray[2]);
                    Object[] objectArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = stringArray[i + 3];
                    }
                    ObservableList observableList = FXCollections.observableArrayList((Object[])objectArray);
                    MenuPane.this.fxLanComboBox.setItems(observableList);
                }
            }
        });
        this.statusSettingMethodMap.put("LANGUAGE", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    MenuPane.this.fxLanComboBox.getSelectionModel().select((Object)stringArray[3]);
                }
            }
        });
        this.statusSettingMethodMap.put("TTS_ENABLE", new setCurrentStatus(){

            public void DisableTtsButton() {
                MenuPane.this.TtsModeBtn.setOn(false);
                MenuPane.this.TtsModeBtn.setDisable(true);
            }

            public void EnableTtsButton() {
                MenuPane.this.TtsModeBtn.setDisable(false);
            }

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    if (stringArray[3].equals("tts_enable")) {
                        this.EnableTtsButton();
                    } else if (stringArray[3].equals("tts_disable")) {
                        this.DisableTtsButton();
                    }
                }
            }
        });
        this.statusSettingMethodMap.put("CLOCK_MODE", new setCurrentStatus(){

            public void SelectAutoButton() {
                MenuPane.this.AutoBtn.setSelected(true);
                MenuPane.this.ManualBtn.setSelected(false);
            }

            public void SelectManualButton() {
                MenuPane.this.AutoBtn.setSelected(false);
                MenuPane.this.ManualBtn.setSelected(true);
            }

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs")) {
                    if (stringArray[3].equals("auto")) {
                        this.SelectAutoButton();
                    } else if (stringArray[3].equals("manual")) {
                        this.SelectManualButton();
                    }
                }
            }
        });
        this.statusSettingMethodMap.put("DATE", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs") && stringArray[2].equals("3")) {
                    MenuPane.this.fxDateMonth.getSelectionModel().select((Object)stringArray[3]);
                    MenuPane.this.fxDateDay.getSelectionModel().select((Object)stringArray[4]);
                    MenuPane.this.fxDateYear.getSelectionModel().select((Object)stringArray[5]);
                }
            }
        });
        this.statusSettingMethodMap.put("TIME", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray[1].equals("sucs") && stringArray[2].equals("3")) {
                    MenuPane.this.fxClockHour.getSelectionModel().select((Object)stringArray[3]);
                    MenuPane.this.fxClockMinute.getSelectionModel().select((Object)stringArray[4]);
                    MenuPane.this.fxClockAM.getSelectionModel().select((Object)stringArray[5]);
                }
            }
        });
        this.statusSettingMethodMap.put("ERROR", new setCurrentStatus(){

            @Override
            public void setStatus(String string) {
                String[] stringArray = string.split("&!;");
                if (stringArray.length == 2) {
                    String string2 = stringArray[1];
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Error");
                    alert.setHeaderText(null);
                    alert.setContentText(string2);
                    alert.showAndWait();
                }
            }
        });
        this.isInitialize = true;
        EventMgr.getInstance().AddLsn("menu", (ILsn)this);
        this.sendMenuMessage(15, 230);
    }

    private void sendMenuMessage(int n, int n2) {
        this.sendMenuMessage(n, n2, "");
    }

    private void sendMenuMessage(int n, int n2, String string) {
        MessageSender.getInstance().sendInjectorReq("menu", n, n2, string);
    }

    private String MakeSimpleMessage(String ... stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            string = string + string2 + ":";
        }
        return string;
    }

    private String MakeManualClockSettingMessage() {
        String string = "manual:";
        for (ComboBox<String> comboBox : this.ClockComboBoxList) {
            string = string + (String)comboBox.getValue() + ":";
        }
        return string;
    }

    @FXML
    public void onClickClockApplyBtn(ActionEvent actionEvent) {
        String string = "";
        string = this.ManualBtn.isSelected() ? this.MakeManualClockSettingMessage() : "auto";
        string.trim();
        this.sendMenuMessage(240, 239, string);
    }

    @FXML
    public void onClickLanApplyBtn(ActionEvent actionEvent) {
        String string = (String)this.fxLanComboBox.getValue();
        this.sendMenuMessage(240, 232, string);
    }

    @FXML
    public void onClickDeviceNameApplyBtn(ActionEvent actionEvent) {
        String string = this.fxDeviceName.getText().toString();
        this.sendMenuMessage(240, 238, string);
    }

    static interface setCurrentStatus {
        public void setStatus(String var1);
    }
}

