/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.tuner.TunerData;
import org.tizen.ecp.tuner.TunerList;
import org.tizen.ecp.tuner.TunerPtc;
import org.tizen.ecp.utils.FilePath;

public class TunerConfiguration {
    private String tunerDirectory;
    public static String test;
    private String tunerConfigFilePath = "init";
    private int listIndexCLI = 0;
    private static TunerConfiguration instance;
    private int T_COUNTRY = 1;

    public int getTableItemCount() {
        return this.listIndexCLI;
    }

    public static TunerConfiguration getInstance() {
        if (instance == null) {
            instance = new TunerConfiguration();
        }
        return instance;
    }

    public String findTunerConfigFile() {
        String string = VMInfo.getInstance().getVMName();
        this.tunerDirectory = FilePath.getInstance().getVmsPath() + File.separator + string;
        this.tunerConfigFilePath = this.tunerDirectory + File.separator + "tuner_default.cfg";
        return this.tunerConfigFilePath;
    }

    public String getTunerConfigFile() {
        if (this.tunerConfigFilePath.equalsIgnoreCase("init")) {
            this.findTunerConfigFile();
        }
        return this.tunerConfigFilePath;
    }

    public void setTunerConfigFile(String string) {
        this.tunerConfigFilePath = string;
        OutputUtil.println((String)("test tunerConfigFilePath = " + this.tunerConfigFilePath));
    }

    void createTunerTableItem(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        TunerData tunerData;
        boolean bl2 = false;
        bl2 = string == "1";
        if (bl) {
            tunerData = new TunerData(bl2, string2, string3, string4, string5, string6, string7);
        } else {
            tunerData = new TunerData(bl2, "stop", "Air", "8SV", "2", "57000000", string7);
            OutputUtil.println((String)("1 Stop Air 8SV 2 57000000 " + string7));
        }
        TunerList.getInstance().addTunerList(tunerData);
        ++this.listIndexCLI;
    }

    void removeTunerTableItem(int n) {
        TunerList.getInstance().removeTunerList(n - 1);
        --this.listIndexCLI;
    }

    public int updateTunerTableItem(int n, int n2, String string) {
        boolean bl = false;
        ArrayList<TunerData> arrayList = TunerList.getInstance().getTunerList();
        if (string == "1") {
            bl = true;
        }
        switch (n2) {
            case 1: {
                if (arrayList.get(n).getAir().getValue() == bl) break;
                if (string.equalsIgnoreCase("0") && arrayList.get(n).getTune().getValue().equalsIgnoreCase("Play")) {
                    arrayList.get(n).setTuned("Stop");
                }
                arrayList.get(n).setAir(bl);
                try {
                    this.writeTunerConfig();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                TunerConfiguration.send(1, "0", arrayList.get(n).getFrequency().getValue(), arrayList.get(n).getModulation().getValue());
                break;
            }
            case 2: {
                arrayList.get(n).setTuned(string);
                break;
            }
            case 3: {
                if (this.T_COUNTRY == 1) {
                    if (!string.equalsIgnoreCase("Air") && !string.equalsIgnoreCase("Cable")) {
                        OutputUtil.println((String)"argument is error");
                        return 25;
                    }
                } else if (this.T_COUNTRY == 2) {
                    // empty if block
                }
                arrayList.get(n).setCarrier(string);
                try {
                    this.writeTunerConfig();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 4: {
                arrayList.get(n).setChannel(string);
                String string2 = this.calcFrequency(arrayList, n, string);
                arrayList.get(n).setFrequency(string2);
                try {
                    this.writeTunerConfig();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 5: {
                arrayList.get(n).setTSFile(string);
                try {
                    this.writeTunerConfig();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!arrayList.get(n).getTune().getValue().equalsIgnoreCase("Play")) break;
                if (arrayList.get(n).getAir().getValue().booleanValue()) {
                    TunerConfiguration.send(3, "1", arrayList.get(n).getFrequency().getValue(), arrayList.get(n).getModulation().getValue());
                    break;
                }
                TunerConfiguration.send(3, "0", arrayList.get(n).getFrequency().getValue(), arrayList.get(n).getModulation().getValue());
                break;
            }
        }
        return 0;
    }

    private String calcFrequency(ArrayList<TunerData> arrayList, int n, String string) {
        int n2 = arrayList.get(n).getCarrier().equals("Air") ? 1 : (arrayList.get(n).getCarrier().equals("Std") ? 3 : (arrayList.get(n).getCarrier().equals("Hrc") ? 4 : (arrayList.get(n).getCarrier().equals("Irc") ? 5 : (arrayList.get(n).getCarrier().equals("DVB-T") ? 6 : (arrayList.get(n).getCarrier().equals("DVB-C") ? 7 : (arrayList.get(n).getCarrier().equals("DVB-S") ? 8 : (arrayList.get(n).getCarrier().equals("Tivu") ? 9 : 2)))))));
        int n3 = this.T_COUNTRY;
        int n4 = (int)TunerPtc.getFrequency(n3, n2, Integer.parseInt(string));
        arrayList.get(n).setFrequency(String.valueOf(n4));
        return String.valueOf(n4);
    }

    public void writeTunerConfig() throws Exception {
        int n = 1;
        File file = new File(this.tunerConfigFilePath);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        for (n = 0; n < this.listIndexCLI; ++n) {
            if (TunerList.getInstance().getTunerList().get(n).getTSFile() == null || TunerList.getInstance().getTunerList().get(n).getTSFile().equals("")) continue;
            String string = TunerList.getInstance().getTunerList().get(n).getAir().getValue() == true ? "1" : "0";
            String string2 = string;
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getTune();
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getCarrier();
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getModulation();
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getChannel();
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getFrequency();
            string2 = string2 + " ";
            string2 = string2 + TunerList.getInstance().getTunerList().get(n).getTSFile();
            string2 = string2 + "\n";
            ((OutputStream)fileOutputStream).write(string2.getBytes());
        }
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public void loadTunerConfig(boolean bl) throws IOException {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tunerConfigFilePath));
            while ((string = bufferedReader.readLine()) != null) {
                int n = 0;
                int n2 = 0;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                n2 = string.indexOf(" ", n);
                string2 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(" ", n);
                string3 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(" ", n);
                string4 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(" ", n);
                string5 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(" ", n);
                string6 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(" ", n);
                string7 = string.substring(n, n2);
                n = n2 + 1;
                string8 = string.substring(n, string.length());
                if (bl) {
                    OutputUtil.println((String)(string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6 + " " + string7 + " " + string8));
                }
                this.createTunerTableItem(true, string2, string3, string4, string5, string6, string7, string8);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            OutputUtil.println((String)"No tuner_table.cfg file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void send(int n, String string, String string2, String string3) {
        String string4 = "";
        string4 = string + ":" + string2 + ":" + string3 + ":";
        OutputUtil.println((String)("send() : data=" + string4));
        MessageSender.getInstance().sendDeviceReq("tuner", 0, n, string4);
    }

    static {
        instance = null;
    }
}

