/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.json.simple.JSONObject;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.control.TizenToggleButton;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.tuner.TunerChannelList;
import org.tizen.ecp.tuner.TunerData;
import org.tizen.ecp.tuner.TunerList;
import org.tizen.ecp.tuner.TunerPane;
import org.tizen.ecp.tuner.TunerPtc;
import org.tizen.ecp.tuner.TunerTable;
import org.tizen.ecp.tuner.TunerTableATSC;
import org.tizen.ecp.tuner.TunerTableDVB;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;

public class TunerController
implements Initializable {
    private TunerTable table;
    TunerData tData;
    @FXML
    HBox fx_status_toggle;
    @FXML
    Label fxConfigLabel;
    @FXML
    Label fxSystemLabel;
    @FXML
    Label fxCountryLabel;
    @FXML
    Label fxStillImage;
    @FXML
    TableView<TunerData> fxTunerTable;
    @FXML
    TableColumn<TunerData, String> fxNum;
    @FXML
    TableColumn<TunerData, String> fxOnAir;
    @FXML
    TableColumn<TunerData, String> fxCarrier;
    @FXML
    TableColumn<TunerData, String> fxModul;
    @FXML
    TableColumn<TunerData, String> fxChannel;
    @FXML
    TableColumn<TunerData, String> fxFreq;
    @FXML
    TableColumn<TunerData, Boolean> fxAir;
    @FXML
    TableColumn<TunerData, String> fxFile;
    @FXML
    Button fxNewBtn;
    @FXML
    Button fxLoadBtn;
    @FXML
    Button fxSaveasBtn;
    @FXML
    Button fxAddBtn;
    @FXML
    Button fxRemoveBtn;
    ObservableList<TunerData> tunerList = FXCollections.observableArrayList();
    ObservableList<String> cbValues = FXCollections.observableArrayList((Object[])new String[]{"1", "2", "3"});
    ObservableList<Boolean> cblist = FXCollections.observableArrayList((Object[])new Boolean[]{true, true, true});
    @FXML
    private TextField fxHostDirTxt;
    private TunerChannelList ch_list;
    private String tunerConfigFilePath;
    private FileChooser fileChooser;
    TunerPane tPane = new TunerPane();
    int T_SYSTEM;
    int T_COUNTRY;
    String sysLabel;
    String countryLabel;
    private String StillStatus;
    TizenToggleButton status_extinput;
    Label stillImg;
    private static Logger logger = LogUtil.getECPLogger(TunerController.class).getLogger();
    @FXML
    private Label fxTitleLab;
    private boolean isInitialize = false;
    private boolean isMount = false;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        String string;
        logger.info("jhonlee::initialize()");
        logger.info("jhonlee::setCellValueFactory::start");
        this.fxTunerTable.setEditable(true);
        this.fxTunerTable.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.fxAir.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TunerData, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<TunerData, Boolean> cellDataFeatures) {
                final TunerData tunerData = (TunerData)cellDataFeatures.getValue();
                SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(tunerData.getAir().get());
                simpleBooleanProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                        tunerData.setAir(bl2);
                        TunerController.this.writeTunerConfig();
                    }
                });
                return simpleBooleanProperty;
            }
        });
        this.fxAir.setCellFactory((Callback)new Callback<TableColumn<TunerData, Boolean>, TableCell<TunerData, Boolean>>(){

            public TableCell<TunerData, Boolean> call(TableColumn<TunerData, Boolean> tableColumn) {
                CheckBoxTableCell checkBoxTableCell = new CheckBoxTableCell();
                checkBoxTableCell.setAlignment(Pos.CENTER);
                return checkBoxTableCell;
            }
        });
        this.fxAir.setEditable(true);
        this.fxOnAir.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getTune());
        this.fxCarrier.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getCarrier());
        this.fxCarrier.setMinWidth(80.0);
        this.fxCarrier.setEditable(true);
        this.fxCarrier.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fxCarrier.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TunerData, String>>(){

            public void handle(TableColumn.CellEditEvent<TunerData, String> cellEditEvent) {
                ((TunerData)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow())).setCarrier((String)cellEditEvent.getNewValue());
                TunerController.this.writeTunerConfig();
            }
        });
        this.fxModul.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getModulation());
        this.fxModul.setMinWidth(80.0);
        this.fxModul.setEditable(true);
        this.fxModul.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fxModul.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TunerData, String>>(){

            public void handle(TableColumn.CellEditEvent<TunerData, String> cellEditEvent) {
                ((TunerData)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow())).setModulation((String)cellEditEvent.getNewValue());
                TunerController.this.writeTunerConfig();
            }
        });
        this.fxChannel.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getChannel());
        this.fxChannel.setMinWidth(80.0);
        this.fxChannel.setEditable(true);
        this.fxChannel.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fxChannel.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TunerData, String>>(){

            public void handle(TableColumn.CellEditEvent<TunerData, String> cellEditEvent) {
                ((TunerData)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow())).setChannel((String)cellEditEvent.getNewValue());
                TunerController.this.writeTunerConfig();
            }
        });
        this.fxFreq.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getFrequency());
        this.fxFreq.setMinWidth(80.0);
        this.fxFreq.setEditable(true);
        this.fxFreq.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fxFreq.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TunerData, String>>(){

            public void handle(TableColumn.CellEditEvent<TunerData, String> cellEditEvent) {
                ((TunerData)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow())).setFrequency((String)cellEditEvent.getNewValue());
                TunerController.this.writeTunerConfig();
            }
        });
        this.fxFile.setCellValueFactory(cellDataFeatures -> ((TunerData)cellDataFeatures.getValue()).getTSFile());
        this.fxFile.setMinWidth(80.0);
        this.fxFile.setEditable(true);
        this.fxFile.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fxFile.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TunerData, String>>(){

            public void handle(TableColumn.CellEditEvent<TunerData, String> cellEditEvent) {
                ((TunerData)cellEditEvent.getTableView().getItems().get(cellEditEvent.getTablePosition().getRow())).setTSFile((String)cellEditEvent.getNewValue());
                TunerController.this.writeTunerConfig();
            }
        });
        this.fxFile.setMinWidth(100.0);
        this.fxTunerTable.setEditable(true);
        this.findTunerConfigFile();
        this.ch_list = new TunerChannelList();
        try {
            this.createTunerTable();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = exception.toString();
            logger.severe("jhonlee::error:: " + string);
        }
        try {
            this.status_extinput = new TizenToggleButton("ON", "OFF");
            this.status_extinput.setOn(false);
            this.stillImg = new Label("   Still Image");
            this.fx_status_toggle.getChildren().add((Object)this.stillImg);
            this.fx_status_toggle.getChildren().add((Object)this.status_extinput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = exception.toString();
            logger.severe("jhonlee::error2:: " + string);
        }
        int n = 2;
        n = this.searchEmptyChannel();
    }

    private void createTunerTable() {
        if (null != this.table) {
            return;
        }
        if (this.T_SYSTEM == 0) {
            this.table = new TunerTableATSC();
            logger.severe("jhonlee::ATSC");
        } else if (this.T_SYSTEM == 1) {
            this.table = new TunerTableDVB();
        }
        this.table.setSystemCountry(this.T_SYSTEM, this.T_COUNTRY);
        this.table.setTunerChannelList(this.ch_list);
        this.ch_list.getChannelNumberIndex("3");
        this.table.setTunerLogger(logger);
        this.table.createTunerTable();
        this.table.setTunerConfigFilePath(this.tunerConfigFilePath);
        this.loadTunerConfig();
        this.fxTunerTable.setItems(this.tunerList);
        this.fxConfigLabel.setText(this.tunerConfigFilePath);
    }

    public String createUsernetMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"info network"), (String)"Network");
        return string;
    }

    public void onClickSaveasBtn(ActionEvent actionEvent) {
        logger.severe("Load");
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
        }
        File file = this.fileChooser.showSaveDialog(null);
        String string = file.getPath();
        logger.info("selected :" + string);
        if (string != null) {
            String string2 = this.tunerConfigFilePath;
            this.tunerConfigFilePath = string;
            try {
                this.table.setTunerConfigFilePath(this.tunerConfigFilePath);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string3 = exception.toString();
                logger.severe(string3);
            }
            this.table.writeTunerConfig();
            this.tunerConfigFilePath = string2;
            this.table.setTunerConfigFilePath(this.tunerConfigFilePath);
            logger.info("save path:" + string);
        }
    }

    public void onClickNewBtn(ActionEvent actionEvent) {
        logger.severe("Load");
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
        }
        File file = this.fileChooser.showOpenDialog(null);
        String string = file.getPath();
        logger.severe("selected: " + string);
        this.tunerConfigFilePath = string;
        this.fxConfigLabel.setText(this.tunerConfigFilePath);
        this.removeTable();
        this.ch_list.initChannelList();
        this.loadTunerConfig();
        if (file != null) {
            this.fxTunerTable.setItems(this.tunerList);
        }
        TunerController.send(6, this.tunerConfigFilePath);
    }

    @FXML
    public void onClickMountBtn(ActionEvent actionEvent) {
        this.removeTable();
        this.loadTunerConfig();
    }

    @FXML
    public void onClickStillOnBtn(ActionEvent actionEvent) {
        TunerController.send(5, "1:");
    }

    public void onClickStillOffBtn(ActionEvent actionEvent) {
        TunerController.send(5, "0:");
    }

    @FXML
    public void onClickBrowseBtn(ActionEvent actionEvent) {
        File file;
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
        }
        if ((file = this.fileChooser.showOpenDialog(null)) != null) {
            this.fxHostDirTxt.setText(file.getAbsolutePath());
        }
    }

    @FXML
    public void onClickFileItem(ActionEvent actionEvent) {
        logger.info("============================");
    }

    public void removeTable() {
        this.tunerList.removeAll(this.tunerList);
        this.fxTunerTable.setItems(this.tunerList);
    }

    public void loadTunerConfig() {
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tunerConfigFilePath));
            String string4 = "";
            logger.severe("tunerConfigFilePath: " + this.tunerConfigFilePath);
            while ((string3 = bufferedReader.readLine()) != null) {
                String string5;
                int n;
                String[] stringArray = string3.split(" ");
                if (stringArray.length < 6 || stringArray.length > 7) {
                    logger.severe("The number of items is wrong : " + string3);
                    continue;
                }
                string4 = stringArray.length == 7 ? stringArray[6] : "";
                if (stringArray.length < 6) {
                    logger.severe("The number of items is wrong : " + string3);
                    continue;
                }
                if (stringArray.length >= 7) {
                    string4 = stringArray[6];
                    for (n = 7; n < stringArray.length; ++n) {
                        string4 = string4 + " " + stringArray[n];
                    }
                } else {
                    string4 = "";
                }
                if (!this.checkFormatItems(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4])) {
                    logger.severe("wrong file input : " + string3);
                    continue;
                }
                for (n = 0; n < stringArray.length; ++n) {
                    logger.severe("data[" + n + "]= " + stringArray[n]);
                }
                logger.severe(this.findTsFile_TMP());
                try {
                    Boolean bl = stringArray[0].equalsIgnoreCase("1") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    this.tData = new TunerData(bl, stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], string4);
                    this.createTunerTableItem(true, stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string5 = exception.toString();
                    logger.severe(string5);
                }
                try {
                    this.tunerList.add((Object)this.tData);
                    this.tData.getTSFile().addListener((observableValue, string, string2) -> {});
                    this.fxCountryLabel.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string5 = exception.toString();
                    logger.severe(string5);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception", iOException);
        }
    }

    public boolean checkFormatItems(String string, String string2, String string3, String string4, String string5) {
        int n;
        if (!string.equalsIgnoreCase("1") && !string.equalsIgnoreCase("0")) {
            logger.severe("anttena value is not correct");
            return false;
        }
        if (!string2.equalsIgnoreCase("Play") && !string2.equalsIgnoreCase("Stop")) {
            logger.severe("tune value is not correct");
            return false;
        }
        if (this.T_COUNTRY == 1) {
            if (!string3.equalsIgnoreCase("Air") && !string3.equalsIgnoreCase("Cable")) {
                logger.severe("KOR'carrier value is not correct");
                return false;
            }
            if (!string4.equalsIgnoreCase("8VSB") && !string4.equalsIgnoreCase("QAM256")) {
                logger.severe("modulation value is not correct");
                return false;
            }
        } else if (this.T_COUNTRY == 2) {
            if (!(string3.equalsIgnoreCase("Air") || string3.equalsIgnoreCase("Std") || string3.equalsIgnoreCase("Hrc") || string3.equalsIgnoreCase("Irc"))) {
                logger.severe("USA'carrier value is not correct");
                return false;
            }
            if (!string4.equalsIgnoreCase("8VSB") && !string4.equalsIgnoreCase("QAM256")) {
                logger.severe("modulation value is not correct");
                return false;
            }
        } else if (this.T_COUNTRY == 3) {
            if (!(string3.equalsIgnoreCase("DVB-T") || string3.equalsIgnoreCase("DVB-C") || string3.equalsIgnoreCase("DVB-S") || string3.equalsIgnoreCase("Tivu"))) {
                logger.severe("Euro carrier value is not correct");
                return false;
            }
        } else {
            logger.info("Not implemented");
        }
        if ((n = Integer.parseInt(string5)) > 159 | n < 2) {
            logger.severe("ptc value is not correct");
            return false;
        }
        return true;
    }

    private void findTunerConfigFile() {
        String string = VMInfo.getInstance().getVMName();
        String string2 = FilePath.getInstance().getVmsPath() + File.separator + string;
        this.tunerConfigFilePath = string2 + File.separator + "tuner_default.cfg";
    }

    private String findTsFile_TMP() {
        String string = VMInfo.getInstance().getVMName();
        String string2 = FilePath.getInstance().getVmsPath() + File.separator + string;
        String string3 = string2 + File.separator + "KBS1_news.ts";
        logger.info("tsfile: " + string3);
        return string3;
    }

    public static void send(int n, String string) {
        logger.info("send() : action=" + n + ", data" + string);
        MessageSender.getInstance().sendDeviceReq("tuner", 0, n, string);
    }

    public void send(int n, String string, String string2, String string3) {
        String string4 = string + ":" + string2 + ":" + string3 + ":";
        logger.info("send() : data=" + string4);
        TunerController.send(n, string4);
    }

    public void send(int n) {
        logger.info("send() : action=" + n);
        TunerController.send(n, Integer.toString(n));
    }

    private void createTunerTableItem(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        boolean bl2 = string == "1";
        TunerData tunerData = bl ? new TunerData(bl2, string2, string3, string4, string5, string6, string7) : new TunerData(bl2, "", "", "", string5, "", "");
        TunerList.getInstance().addTunerList(tunerData);
        this.ch_list.ptcAdd(string5);
        float f = TunerPtc.getFrequency(this.T_COUNTRY, 6, Integer.parseInt(string5));
        tunerData.setFrequency(String.valueOf((int)f));
    }

    private int searchEmptyChannel() {
        int n = 2;
        n = 2;
        while (this.hasChannel(n)) {
            ++n;
        }
        return n;
    }

    private boolean hasChannel(int n) {
        ArrayList<TunerData> arrayList = TunerList.getInstance().getTunerList();
        for (TunerData tunerData : arrayList) {
            int n2;
            try {
                n2 = Integer.parseInt(tunerData.getChannel().toString());
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public void writeTunerConfig() {
        try {
            File file = new File(this.tunerConfigFilePath);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            for (TunerData tunerData : this.tunerList) {
                String string = tunerData.getAir().getValue() == true ? "1" : "0";
                string = string + " ";
                string = string + tunerData.getTune().getValue();
                string = string + " ";
                string = string + tunerData.getCarrier().getValue();
                string = string + " ";
                string = string + tunerData.getModulation().getValue();
                string = string + " ";
                string = string + tunerData.getChannel().getValue();
                string = string + " ";
                string = string + tunerData.getFrequency().getValue();
                string = string + " ";
                string = string + tunerData.getTSFile().getValue();
                string = string + "\n";
                ((OutputStream)fileOutputStream).write(string.getBytes());
            }
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "IOException", iOException);
        }
    }
}

