/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.util.logging.Logger;
import org.tizen.ecp.tuner.TunerConstants;
import org.tizen.ecp.utils.LogUtil;

public class TunerPtc {
    static final int FREQ_GAP = 6;
    static final int FREQ_GAP_DVB = 8;
    static final int FRE_AIR = 0;
    static final int FRE_KR = 1;
    static final int FRE_AIRUSA = 2;
    static final int STD_USA = 3;
    static final int HRC_USA = 4;
    static final int IRC_USA = 5;
    static final int DVB_T = 6;
    static final int DVB_C = 7;
    static final int DVB_S = 8;
    static final int DVB_TIVU = 9;
    private static Logger logger = LogUtil.getECPLogger(TunerPtc.class).getLogger();

    TunerPtc() {
    }

    static float getFrequency(int n, int n2, int n3) {
        int n4 = n;
        if (n4 == 1) {
            switch (n2) {
                case 1: {
                    return (float)TunerPtc.freqAtPTC(0, n3);
                }
            }
            return (float)TunerPtc.freqAtPTC(1, n3);
        }
        if (n4 == 2) {
            switch (n2) {
                case 3: {
                    return (float)TunerPtc.freqAtPTC(3, n3);
                }
                case 4: {
                    return (float)TunerPtc.freqAtPTC(4, n3);
                }
                case 5: {
                    return (float)TunerPtc.freqAtPTC(5, n3);
                }
            }
            return (float)TunerPtc.freqAtPTC(2, n3);
        }
        if (n4 == 3) {
            switch (n2) {
                case 6: {
                    return (float)TunerPtc.freqAtPTC(6, n3);
                }
                case 7: {
                    return (float)TunerPtc.freqAtPTC(7, n3);
                }
                case 8: {
                    return (float)TunerPtc.freqAtPTC(8, n3);
                }
                case 9: {
                    return (float)TunerPtc.freqAtPTC(9, n3);
                }
            }
        }
        logger.info("error to get frequency, chType=" + n2);
        return -1.0f;
    }

    static double freqAtPTC(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        double[] dArray = null;
        int n4 = 6;
        switch (n) {
            case 0: {
                dArray = TunerConstants.temp_fre_air;
                break;
            }
            case 1: {
                dArray = TunerConstants.temp_fre_kr;
                break;
            }
            case 2: {
                dArray = TunerConstants.temp_fre_airusa;
                break;
            }
            case 3: {
                dArray = TunerConstants.temp_fre_std;
                break;
            }
            case 4: {
                dArray = TunerConstants.temp_fre_hrc;
                break;
            }
            case 5: {
                dArray = TunerConstants.temp_fre_irc;
            }
            case 6: {
                dArray = TunerConstants.temp_fre_dvb_t;
                n4 = 8;
                break;
            }
            case 7: {
                dArray = TunerConstants.temp_fre_dvb_c;
                n4 = 8;
            }
            case 8: {
                dArray = TunerConstants.temp_fre_dvb_s;
                n4 = 8;
            }
            case 9: {
                dArray = TunerConstants.temp_fre_dvb_tivu;
                n4 = 8;
            }
        }
        n3 = 0;
        while (dArray[n3] != -1.0 && !(dArray[n3] > (double)n2)) {
            n3 += 2;
        }
        if (dArray[n3] == -1.0) {
            return -1.0;
        }
        d = ((double)n2 - dArray[n3 - 2]) * (double)n4 + dArray[n3 - 1];
        d2 = d * 1000000.0;
        logger.info("freqAtPTC, ptc=" + n2 + ", freq_mhz=" + d);
        return d2;
    }

    public static int getChannelType(String string) {
        int n = 0;
        n = string.equalsIgnoreCase("Air") ? 1 : (string.equalsIgnoreCase("Cable") ? 2 : (string.equalsIgnoreCase("Std") ? 3 : (string.equalsIgnoreCase("Hrc") ? 4 : (string.equalsIgnoreCase("DVB-T") ? 6 : (string.equalsIgnoreCase("DVB-C") ? 7 : (string.equalsIgnoreCase("DVB-S") ? 8 : (string.equalsIgnoreCase("Tivu") ? 9 : 5)))))));
        return n;
    }
}

