/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.io.File;
import java.io.IOException;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.tuner.TunerConfiguration;

public class TunerUpdateTableCLI
extends AbstractEmulatorCLI {
    @Argument(required=true, index=0)
    int number;
    @Argument(required=true, index=1)
    String item;
    @Argument(required=true, index=2)
    String val;
    private String path;

    public int execute() {
        this.path = TunerConfiguration.getInstance().findTunerConfigFile();
        File file = new File(this.path);
        if (!file.exists()) {
            OutputUtil.printHelpError((String)"Configuration file must be existed", (String)this.help);
            return 25;
        }
        try {
            TunerConfiguration.getInstance().loadTunerConfig(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.number < 1 || this.number > TunerConfiguration.getInstance().getTableItemCount()) {
            OutputUtil.printHelpError((String)"Table number is error", (String)this.help);
            return 25;
        }
        if (this.item.matches("antena")) {
            TunerConfiguration.getInstance().updateTunerTableItem(this.number - 1, 1, this.val);
        } else if (this.item.matches("carrier")) {
            TunerConfiguration.getInstance().updateTunerTableItem(this.number - 1, 3, this.val);
        } else if (this.item.matches("channel")) {
            TunerConfiguration.getInstance().updateTunerTableItem(this.number - 1, 4, this.val);
        } else if (this.item.matches("file")) {
            File file2 = new File(this.val);
            if (!file2.exists()) {
                OutputUtil.printHelpError((String)"TS file must be existed", (String)this.help);
                return 25;
            }
            TunerConfiguration.getInstance().updateTunerTableItem(this.number - 1, 5, this.val);
        } else {
            OutputUtil.printHelpError((String)"item is incorrect", (String)this.help);
            return 25;
        }
        return 0;
    }
}

