/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.appserver;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.appserver.AppServerModel;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.sock.MessageSender;

public class AppServerController
implements Initializable {
    @FXML
    public GridPane appserverGrid;
    private AppServerModel model;
    private TizenRadioButton operating;
    private TizenRadioButton development;
    private TizenRadioButton developing;
    ChangeListener<Number> statusChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (number2.intValue() == 0) {
                AppServerController.this.operating.setSelected(true);
            } else if (number2.intValue() == 1) {
                AppServerController.this.development.setSelected(true);
            } else if (number2.intValue() == 2) {
                AppServerController.this.developing.setSelected(true);
            }
        }
    };
    ChangeListener<Toggle> toggleChangeListener = new ChangeListener<Toggle>(){

        public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
            int n = -1;
            if (toggle == null) {
                return;
            }
            if (toggle2.equals(AppServerController.this.operating)) {
                n = 0;
            } else if (toggle2.equals(AppServerController.this.development)) {
                n = 1;
            } else if (toggle2.equals(AppServerController.this.developing)) {
                n = 2;
            }
            AppServerController.this.model.setStatus(n);
            AppServerController.this.send(n);
        }
    };

    public AppServerController(AppServerModel appServerModel) {
        this.model = appServerModel;
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.selectedToggleProperty().addListener(this.toggleChangeListener);
        this.operating = this.model.getOperating();
        this.operating.setHgap(18.0);
        this.operating.setToggleGroup(toggleGroup);
        this.appserverGrid.add((Node)this.operating, 1, 1, 3, 1);
        this.development = this.model.getDevelopment();
        this.development.setHgap(18.0);
        this.development.setToggleGroup(toggleGroup);
        this.appserverGrid.add((Node)this.development, 1, 3, 3, 1);
        this.developing = this.model.getDeveloping();
        this.developing.setHgap(18.0);
        this.developing.setToggleGroup(toggleGroup);
        this.appserverGrid.add((Node)this.developing, 1, 5, 3, 1);
        this.model.getStatus().addListener(this.statusChangeListener);
    }

    public void send(int n) {
        MessageSender.getInstance().sendInjectorReq("AppServer", 200, n);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        MessageSender.getInstance().sendInjectorReq("AppServer", 15, 124);
    }
}

