/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.network;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.json.simple.JSONObject;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.network.NetworkController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class NetworkPane
extends ECPPopupPane {
    NetworkController controller;
    Logger logger = LogUtil.getECPLogger(NetworkController.class).getLogger();

    public void onCreate() {
        EventMgr.getInstance().AddLsnSet("Network");
        EventMgr.getInstance().AddLsn("Network", (ILsn)this);
    }

    public void onShow() {
        this.send();
    }

    public Pane create() {
        AnchorPane anchorPane;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("Network.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
            this.controller = (NetworkController)eCPFXMLLoader.getController();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return anchorPane;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        int n = -1;
        int n2 = -1;
        Ecs.InjectorNtf injectorNtf = null;
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            n = injectorNtf.getAction();
            n2 = injectorNtf.getGroup();
            if (123 == n) {
                if (1 == n2) {
                    this.controller.clearNetworkInfo();
                } else if (injectorNtf.getData().toStringUtf8().equals("1")) {
                    MessageBox.error((String)"Failed to add port forwarding. Please try to choose different port.");
                } else {
                    this.logger.warning("not supported message. action: " + n + " ,group: " + n2);
                }
            }
        } else {
            return;
        }
    }

    private void sendCheckNetBridge() {
        MessageSender.getInstance().sendDeviceEcsReq("Network", 0, 123);
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"return");
        if (string2.startsWith("hub")) {
            this.controller.clearNetworkInfo();
            this.controller.setNetworkInfo(string2);
        } else {
            this.controller.setNetworkInfo(string2);
            if (string2.trim().equals("on")) {
                this.controller.setProtocol("Connect");
            } else if (string2.trim().equals("off")) {
                this.controller.setProtocol("Disconnect");
            }
        }
    }

    private String createNetworkConnectMsg(String string) {
        String string2 = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)string), (String)"Network");
        return string2;
    }

    private void send() {
        MessageSender.getInstance().sendMonitorReq(this.createNetworkConnectMsg("get_link virtio-net-pci.0"));
        MessageSender.getInstance().sendMonitorReq(this.createNetworkMsg());
        MessageSender.getInstance().sendMonitorReq(this.controller.createUsernetMsg());
        this.sendCheckNetBridge();
    }

    private String createNetworkMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"Network"), (String)"Network");
        return string;
    }
}

