/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.json.simple.JSONObject;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.tuner.TunerChannelList;
import org.tizen.ecp.tuner.TunerController;
import org.tizen.ecp.tuner.TunerData;
import org.tizen.ecp.tuner.TunerList;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class TunerPane
extends ECPPopupPane {
    Logger logger = LogUtil.getECPLogger(TunerPane.class).getLogger();
    TunerController controller;
    ObservableList<TunerData> tunerList = FXCollections.observableArrayList();
    private TunerChannelList ch_list;
    private String tunerConfigFilePath;
    private FileChooser fileChooser;
    private boolean isInitialize = false;
    private String StillStatus;
    private int T_SYSTEM = -1;
    private int T_COUNTRY = 1;
    private String sysLabel = "System: ";
    private String countryLabel = "Country: ";
    private int k = 0;

    public void onCreate() {
        this.logger.info("jhonlee::onCreate()");
    }

    public void onShow() {
        this.logger.info("jhonlee::onShow()");
        EventMgr.getInstance().AddLsnSet("TUNER_DTV");
        EventMgr.getInstance().AddLsn("TUNER_DTV", (ILsn)this);
        this.send(2);
    }

    public Pane create() {
        VBox vBox;
        this.logger.info("jhonlee::create()");
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("Tuner.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            vBox = (VBox)eCPFXMLLoader.load();
            this.controller = (TunerController)eCPFXMLLoader.getController();
            this.logger.info("jhonlee:: innnnnnn create()");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = iOException.toString();
            this.logger.severe("jhonlee::error:: " + string);
            return null;
        }
        return vBox;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        this.logger.info("jhonlee::002Porc");
        int n = -1;
        int n2 = -1;
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        this.logger.info("Tuner OnEventProcPB");
        String string = ((Ecs.DeviceNtf)generatedMessage).getData().toStringUtf8();
        String[] stringArray = string.split(":");
        String string2 = "";
        if (stringArray.length < 6) {
            this.logger.severe("wrong format of received data. length=" + stringArray.length);
            this.logger.severe("received data = " + string);
            return;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = stringArray[3];
        String string7 = stringArray[4];
        String string8 = stringArray[5];
        if (stringArray.length == 6) {
            this.logger.info("ts is null");
        } else {
            string2 = stringArray[6];
        }
        if (stringArray.length == 8) {
            String string9 = stringArray[7];
            string2 = string2 + ":" + string9;
        }
        this.logger.info("Received from ECS, ant=" + string3 + "   freq=" + string4 + "   mod=" + string5 + "\tsys=" + string6 + "   country=" + string7 + "   still_mode=" + string8 + "   TS path=" + string2);
        if (string6.equalsIgnoreCase("0")) {
            this.T_SYSTEM = 0;
            this.sysLabel = this.sysLabel + "ATSC";
            if (string7.equalsIgnoreCase("0")) {
                this.T_COUNTRY = 1;
                this.countryLabel = this.countryLabel + "KOR";
            } else {
                this.T_COUNTRY = 2;
                this.countryLabel = this.countryLabel + "USA";
            }
        } else if (string6.equalsIgnoreCase("1")) {
            this.T_SYSTEM = 1;
            this.T_COUNTRY = 3;
            this.sysLabel = this.sysLabel + "DVB";
            this.countryLabel = "";
        } else {
            this.logger.info("ERROR : Not supported system");
            return;
        }
        this.logger.info("T_SYSTEM:" + this.T_SYSTEM + ", T_COUNTRY: " + this.T_COUNTRY);
        this.logger.info("sysLabel::" + this.sysLabel + ", countryLabel: " + this.countryLabel);
        this.controller.fxSystemLabel.setText(this.sysLabel);
        this.controller.fxCountryLabel.setText(this.countryLabel);
        if (string3.equalsIgnoreCase("0") && string4.equalsIgnoreCase("0") && string5.equalsIgnoreCase("13")) {
            this.logger.info("Not tuned yet!");
            boolean bl = false;
        } else {
            boolean bl = true;
        }
    }

    private void send() {
        MessageSender.getInstance().sendMonitorReq(this.createTunerkMsg());
        MessageSender.getInstance().sendMonitorReq(this.controller.createUsernetMsg());
    }

    public void send(int n) {
        this.logger.info("send() : action=" + n);
        this.send(n, Integer.toString(n));
    }

    public void send(int n, String string) {
        this.logger.info("send() : action=" + n + ", data" + string);
        MessageSender.getInstance().sendDeviceReq("tuner", 0, n, string);
    }

    private String createTunerkMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"info network"), (String)"tuner");
        return string;
    }

    public boolean updateTunerList(boolean bl, String string, boolean bl2) {
        int n = 0;
        boolean bl3 = false;
        this.logger.info("ant=" + bl + "  freq=" + string + "  tune=" + bl2 + "   in updateTunerList()");
        ArrayList<TunerData> arrayList = TunerList.getInstance().getTunerList();
        for (int i = 5; i < 3; i += 7) {
            n = i / 7;
            this.logger.info("a:" + i + "   index:" + n + "   " + arrayList.get(i / 7));
            if (!bl2) {
                arrayList.get(n).setTuned("Stop");
            }
            if (arrayList.get(i / 7).getFrequency().equals(string)) {
                this.logger.info("Matching a tune index=" + n);
                if (!bl) continue;
                arrayList.get(n).setTuned("Play");
                bl3 = true;
                continue;
            }
            arrayList.get(n).setTuned("Stop");
        }
        this.ch_list.initChannelList();
        this.controller.loadTunerConfig();
        return bl3;
    }
}

