/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.tuner;

import java.util.logging.Logger;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.tuner.TunerChannelList;
import org.tizen.ecp.views.popup.ECPPopupView;

public abstract class TunerTable
extends ECPPopupView {
    protected int T_SYSTEM = 1;
    protected int T_COUNTRY = 3;
    protected TunerChannelList ch_list;
    protected static Logger logger;
    public String tunerConfigFilePath;

    public static void send(int n, String string) {
        logger.info("send() : action=" + n + ", data" + string);
        MessageSender.getInstance().sendDeviceReq("tuner", 0, n, string);
    }

    public void send(int n, String string, String string2, String string3) {
        String string4 = string + ":" + string2 + ":" + string3 + ":";
        logger.info("send() : data=" + string4);
        TunerTable.send(n, string4);
    }

    public void send(int n) {
        logger.info("send() : action=" + n);
        TunerTable.send(n, Integer.toString(n));
    }

    public void setTunerChannelList(TunerChannelList tunerChannelList) {
        this.ch_list = tunerChannelList;
    }

    public void setTunerLogger(Logger logger) {
        TunerTable.logger = logger;
    }

    public void setTunerConfigFilePath(String string) {
        logger.info("jhonlee : path=" + string);
        this.tunerConfigFilePath = string;
    }

    public abstract boolean updateTunerList(boolean var1, String var2, boolean var3);

    public void testCode() {
        logger.severe("jhonlee:: testCode");
    }

    public void setSystemCountry(int n, int n2) {
        this.T_SYSTEM = n;
        this.T_COUNTRY = n2;
    }

    public abstract void createTunerTable();

    public void removeTable() {
        logger.info("jhonlee : removeTable()");
    }

    public abstract String[] loadTunerConfig();

    public abstract void writeTunerConfig();

    public abstract void removeTableSelectedItem();

    public boolean checkFormatItems(String string, String string2, String string3, String string4, String string5) {
        int n;
        if (!string.equalsIgnoreCase("1") && !string.equalsIgnoreCase("0")) {
            logger.severe("anttena value is not correct");
            return false;
        }
        if (!string2.equalsIgnoreCase("Play") && !string2.equalsIgnoreCase("Stop")) {
            logger.severe("tune value is not correct");
            return false;
        }
        if (this.T_COUNTRY == 1) {
            if (!string3.equalsIgnoreCase("Air") && !string3.equalsIgnoreCase("Cable")) {
                logger.severe("KOR'carrier value is not correct");
                return false;
            }
            if (!string4.equalsIgnoreCase("8VSB") && !string4.equalsIgnoreCase("QAM256")) {
                logger.severe("modulation value is not correct");
                return false;
            }
        } else if (this.T_COUNTRY == 2) {
            if (!(string3.equalsIgnoreCase("Air") || string3.equalsIgnoreCase("Std") || string3.equalsIgnoreCase("Hrc") || string3.equalsIgnoreCase("Irc"))) {
                logger.severe("USA'carrier value is not correct");
                return false;
            }
            if (!string4.equalsIgnoreCase("8VSB") && !string4.equalsIgnoreCase("QAM256")) {
                logger.severe("modulation value is not correct");
                return false;
            }
        } else if (this.T_COUNTRY == 3) {
            if (!(string3.equalsIgnoreCase("DVB-T") || string3.equalsIgnoreCase("DVB-C") || string3.equalsIgnoreCase("DVB-S") || string3.equalsIgnoreCase("Tivu"))) {
                logger.severe("Euro carrier value is not correct");
                return false;
            }
        } else {
            logger.info("Not implemented");
        }
        if ((n = Integer.parseInt(string5)) > 159 | n < 2) {
            logger.severe("ptc value is not correct");
            return false;
        }
        return true;
    }

    public abstract void createTunerTableItem(int var1);
}

