/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    private int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        for (Descriptors.FieldDescriptor object : this.getDescriptorForType().getFields()) {
            if (!object.isRequired() || this.hasField(object)) continue;
            return false;
        }
        for (Map.Entry entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (fieldDescriptor.isRepeated()) {
                for (Message message : (List)entry.getValue()) {
                    if (message.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> findInitializationErrors() {
        return Builder.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
    }

    private static String delimitWithCommas(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        boolean bl = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            if (bl && fieldDescriptor.isExtension() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !fieldDescriptor.isRepeated()) {
                codedOutputStream.writeMessageSetExtension(fieldDescriptor.getNumber(), (Message)object);
                continue;
            }
            FieldSet.writeField(fieldDescriptor, object, codedOutputStream);
        }
        UnknownFieldSet unknownFieldSet = this.getUnknownFields();
        if (bl) {
            unknownFieldSet.writeAsMessageSetTo(codedOutputStream);
        } else {
            unknownFieldSet.writeTo(codedOutputStream);
        }
    }

    @Override
    public int getSerializedSize() {
        int n = this.memoizedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        boolean bl = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            if (bl && fieldDescriptor.isExtension() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !fieldDescriptor.isRepeated()) {
                n += CodedOutputStream.computeMessageSetExtensionSize(fieldDescriptor.getNumber(), (Message)object);
                continue;
            }
            n += FieldSet.computeFieldSize(fieldDescriptor, object);
        }
        UnknownFieldSet unknownFieldSet = this.getUnknownFields();
        n = bl ? (n += unknownFieldSet.getSerializedSizeAsMessageSet()) : (n += unknownFieldSet.getSerializedSize());
        this.memoizedSize = n;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        if (this.getDescriptorForType() != message.getDescriptorForType()) {
            return false;
        }
        return ((Object)this.getAllFields()).equals(message.getAllFields()) && this.getUnknownFields().equals(message.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int n = 41;
        n = 19 * n + this.getDescriptorForType().hashCode();
        n = this.hashFields(n, this.getAllFields());
        n = 29 * n + this.getUnknownFields().hashCode();
        return n;
    }

    protected int hashFields(int n, Map<Descriptors.FieldDescriptor, Object> map) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            n = 37 * n + fieldDescriptor.getNumber();
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                n = 53 * n + object.hashCode();
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                List list = (List)object;
                n = 53 * n + AbstractMessage.hashEnumList(list);
                continue;
            }
            n = 53 * n + AbstractMessage.hashEnum((Internal.EnumLite)object);
        }
        return n;
    }

    protected static int hashLong(long l) {
        return (int)(l ^ l >>> 32);
    }

    protected static int hashBoolean(boolean bl) {
        return bl ? 1231 : 1237;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    protected static int hashEnum(Internal.EnumLite enumLite) {
        return enumLite.getNumber();
    }

    protected static int hashEnumList(List<? extends Internal.EnumLite> list) {
        int n = 1;
        for (Internal.EnumLite enumLite : list) {
            n = 31 * n + AbstractMessage.hashEnum(enumLite);
        }
        return n;
    }

    public static abstract class Builder<BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType>
    implements Message.Builder {
        @Override
        public abstract BuilderType clone();

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return Builder.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return AbstractMessage.delimitWithCommas(this.findInitializationErrors());
        }

        public BuilderType mergeFrom(Message message) {
            if (message.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
                if (fieldDescriptor.isRepeated()) {
                    for (Object e : (List)entry.getValue()) {
                        this.addRepeatedField(fieldDescriptor, e);
                    }
                    continue;
                }
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message message2 = (Message)this.getField(fieldDescriptor);
                    if (message2 == message2.getDefaultInstanceForType()) {
                        this.setField(fieldDescriptor, entry.getValue());
                        continue;
                    }
                    this.setField(fieldDescriptor, message2.newBuilderForType().mergeFrom(message2).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(fieldDescriptor, entry.getValue());
            }
            this.mergeUnknownFields(message.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream) throws IOException {
            return (BuilderType)this.mergeFrom(codedInputStream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            UnknownFieldSet.Builder builder = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((n = codedInputStream.readTag()) != 0 && Builder.mergeFieldFrom(codedInputStream, builder, extensionRegistryLite, this.getDescriptorForType(), this, null, n)) {
            }
            this.setUnknownFields(builder.build());
            return (BuilderType)this;
        }

        private static void addRepeatedField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet, Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            if (builder != null) {
                builder.addRepeatedField(fieldDescriptor, object);
            } else {
                fieldSet.addRepeatedField(fieldDescriptor, object);
            }
        }

        private static void setField(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet, Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            if (builder != null) {
                builder.setField(fieldDescriptor, object);
            } else {
                fieldSet.setField(fieldDescriptor, object);
            }
        }

        private static boolean hasOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet, Descriptors.FieldDescriptor fieldDescriptor) {
            if (builder != null) {
                return builder.hasField(fieldDescriptor);
            }
            return fieldSet.hasField(fieldDescriptor);
        }

        private static Message getOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet, Descriptors.FieldDescriptor fieldDescriptor) {
            if (builder != null) {
                return (Message)builder.getField(fieldDescriptor);
            }
            return (Message)fieldSet.getField(fieldDescriptor);
        }

        private static void mergeOriginalMessage(Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet, Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder2) {
            Message message = Builder.getOriginalMessage(builder, fieldSet, fieldDescriptor);
            if (message != null) {
                builder2.mergeFrom(message);
            }
        }

        static boolean mergeFieldFrom(CodedInputStream codedInputStream, UnknownFieldSet.Builder builder, ExtensionRegistryLite extensionRegistryLite, Descriptors.Descriptor descriptor, Message.Builder builder2, FieldSet<Descriptors.FieldDescriptor> fieldSet, int n) throws IOException {
            Descriptors.FieldDescriptor fieldDescriptor;
            if (descriptor.getOptions().getMessageSetWireFormat() && n == WireFormat.MESSAGE_SET_ITEM_TAG) {
                Builder.mergeMessageSetExtensionFromCodedStream(codedInputStream, builder, extensionRegistryLite, descriptor, builder2, fieldSet);
                return true;
            }
            int n2 = WireFormat.getTagWireType(n);
            int n3 = WireFormat.getTagFieldNumber(n);
            Message message = null;
            if (descriptor.isExtensionNumber(n3)) {
                if (extensionRegistryLite instanceof ExtensionRegistry) {
                    ExtensionRegistry.ExtensionInfo extensionInfo = ((ExtensionRegistry)extensionRegistryLite).findExtensionByNumber(descriptor, n3);
                    if (extensionInfo == null) {
                        fieldDescriptor = null;
                    } else {
                        fieldDescriptor = extensionInfo.descriptor;
                        message = extensionInfo.defaultInstance;
                        if (message == null && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            throw new IllegalStateException("Message-typed extension lacked default instance: " + fieldDescriptor.getFullName());
                        }
                    }
                } else {
                    fieldDescriptor = null;
                }
            } else {
                fieldDescriptor = builder2 != null ? descriptor.findFieldByNumber(n3) : null;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (fieldDescriptor == null) {
                bl = true;
            } else if (n2 == FieldSet.getWireFormatForFieldType(fieldDescriptor.getLiteType(), false)) {
                bl2 = false;
            } else if (fieldDescriptor.isPackable() && n2 == FieldSet.getWireFormatForFieldType(fieldDescriptor.getLiteType(), true)) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl) {
                return builder.mergeFieldFrom(n, codedInputStream);
            }
            if (bl2) {
                int n4 = codedInputStream.readRawVarint32();
                int n5 = codedInputStream.pushLimit(n4);
                if (fieldDescriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                    while (codedInputStream.getBytesUntilLimit() > 0) {
                        int n6 = codedInputStream.readEnum();
                        Descriptors.EnumValueDescriptor enumValueDescriptor = fieldDescriptor.getEnumType().findValueByNumber(n6);
                        if (enumValueDescriptor == null) {
                            return true;
                        }
                        Builder.addRepeatedField(builder2, fieldSet, fieldDescriptor, enumValueDescriptor);
                    }
                } else {
                    while (codedInputStream.getBytesUntilLimit() > 0) {
                        Object object = FieldSet.readPrimitiveField(codedInputStream, fieldDescriptor.getLiteType());
                        Builder.addRepeatedField(builder2, fieldSet, fieldDescriptor, object);
                    }
                }
                codedInputStream.popLimit(n5);
            } else {
                Object object;
                switch (fieldDescriptor.getType()) {
                    case GROUP: {
                        Message.Builder builder3 = message != null ? message.newBuilderForType() : builder2.newBuilderForField(fieldDescriptor);
                        if (!fieldDescriptor.isRepeated()) {
                            Builder.mergeOriginalMessage(builder2, fieldSet, fieldDescriptor, builder3);
                        }
                        codedInputStream.readGroup(fieldDescriptor.getNumber(), builder3, extensionRegistryLite);
                        object = builder3.buildPartial();
                        break;
                    }
                    case MESSAGE: {
                        Message.Builder builder4 = message != null ? message.newBuilderForType() : builder2.newBuilderForField(fieldDescriptor);
                        if (!fieldDescriptor.isRepeated()) {
                            Builder.mergeOriginalMessage(builder2, fieldSet, fieldDescriptor, builder4);
                        }
                        codedInputStream.readMessage(builder4, extensionRegistryLite);
                        object = builder4.buildPartial();
                        break;
                    }
                    case ENUM: {
                        int n7 = codedInputStream.readEnum();
                        object = fieldDescriptor.getEnumType().findValueByNumber(n7);
                        if (object != null) break;
                        builder.mergeVarintField(n3, n7);
                        return true;
                    }
                    default: {
                        object = FieldSet.readPrimitiveField(codedInputStream, fieldDescriptor.getLiteType());
                    }
                }
                if (fieldDescriptor.isRepeated()) {
                    Builder.addRepeatedField(builder2, fieldSet, fieldDescriptor, object);
                } else {
                    Builder.setField(builder2, fieldSet, fieldDescriptor, object);
                }
            }
            return true;
        }

        private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream codedInputStream, UnknownFieldSet.Builder builder, ExtensionRegistryLite extensionRegistryLite, Descriptors.Descriptor descriptor, Message.Builder builder2, FieldSet<Descriptors.FieldDescriptor> fieldSet) throws IOException {
            int n;
            int n2 = 0;
            ByteString byteString = null;
            ExtensionRegistry.ExtensionInfo extensionInfo = null;
            while ((n = codedInputStream.readTag()) != 0) {
                if (n == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                    n2 = codedInputStream.readUInt32();
                    if (n2 == 0 || !(extensionRegistryLite instanceof ExtensionRegistry)) continue;
                    extensionInfo = ((ExtensionRegistry)extensionRegistryLite).findExtensionByNumber(descriptor, n2);
                    continue;
                }
                if (n == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                    if (n2 != 0 && extensionInfo != null && ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                        Builder.eagerlyMergeMessageSetExtension(codedInputStream, extensionInfo, extensionRegistryLite, builder2, fieldSet);
                        byteString = null;
                        continue;
                    }
                    byteString = codedInputStream.readBytes();
                    continue;
                }
                if (codedInputStream.skipField(n)) continue;
                break;
            }
            codedInputStream.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
            if (byteString != null && n2 != 0) {
                if (extensionInfo != null) {
                    Builder.mergeMessageSetExtensionFromBytes(byteString, extensionInfo, extensionRegistryLite, builder2, fieldSet);
                } else if (byteString != null) {
                    builder.mergeField(n2, UnknownFieldSet.Field.newBuilder().addLengthDelimited(byteString).build());
                }
            }
        }

        private static void eagerlyMergeMessageSetExtension(CodedInputStream codedInputStream, ExtensionRegistry.ExtensionInfo extensionInfo, ExtensionRegistryLite extensionRegistryLite, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet) throws IOException {
            Descriptors.FieldDescriptor fieldDescriptor = extensionInfo.descriptor;
            Message message = null;
            if (Builder.hasOriginalMessage(builder, fieldSet, fieldDescriptor)) {
                Message message2 = Builder.getOriginalMessage(builder, fieldSet, fieldDescriptor);
                Message.Builder builder2 = message2.toBuilder();
                codedInputStream.readMessage(builder2, extensionRegistryLite);
                message = builder2.buildPartial();
            } else {
                message = codedInputStream.readMessage(extensionInfo.defaultInstance.getParserForType(), extensionRegistryLite);
            }
            if (builder != null) {
                builder.setField(fieldDescriptor, message);
            } else {
                fieldSet.setField(fieldDescriptor, message);
            }
        }

        private static void mergeMessageSetExtensionFromBytes(ByteString byteString, ExtensionRegistry.ExtensionInfo extensionInfo, ExtensionRegistryLite extensionRegistryLite, Message.Builder builder, FieldSet<Descriptors.FieldDescriptor> fieldSet) throws IOException {
            Descriptors.FieldDescriptor fieldDescriptor = extensionInfo.descriptor;
            boolean bl = Builder.hasOriginalMessage(builder, fieldSet, fieldDescriptor);
            if (bl || ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                Message message = null;
                if (bl) {
                    Message message2 = Builder.getOriginalMessage(builder, fieldSet, fieldDescriptor);
                    Message.Builder builder2 = message2.toBuilder();
                    builder2.mergeFrom(byteString, extensionRegistryLite);
                    message = builder2.buildPartial();
                } else {
                    message = extensionInfo.defaultInstance.getParserForType().parsePartialFrom(byteString, extensionRegistryLite);
                }
                Builder.setField(builder, fieldSet, fieldDescriptor, message);
            } else {
                LazyField lazyField = new LazyField(extensionInfo.defaultInstance, extensionRegistryLite, byteString);
                if (builder != null) {
                    if (builder instanceof GeneratedMessage.ExtendableBuilder) {
                        builder.setField(fieldDescriptor, lazyField);
                    } else {
                        builder.setField(fieldDescriptor, lazyField.getValue());
                    }
                } else {
                    fieldSet.setField(fieldDescriptor, lazyField);
                }
            }
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFieldSet).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor fieldDescriptor) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(Builder.findMissingFields(message));
        }

        private static List<String> findMissingFields(MessageOrBuilder messageOrBuilder) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Builder.findMissingFields(messageOrBuilder, "", arrayList);
            return arrayList;
        }

        private static void findMissingFields(MessageOrBuilder messageOrBuilder, String string, List<String> list) {
            for (Descriptors.FieldDescriptor object : messageOrBuilder.getDescriptorForType().getFields()) {
                if (!object.isRequired() || messageOrBuilder.hasField(object)) continue;
                list.add(string + object.getName());
            }
            for (Map.Entry entry : messageOrBuilder.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
                Object v = entry.getValue();
                if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                if (fieldDescriptor.isRepeated()) {
                    int n = 0;
                    for (Object e : (List)v) {
                        Builder.findMissingFields((MessageOrBuilder)e, Builder.subMessagePrefix(string, fieldDescriptor, n++), list);
                    }
                    continue;
                }
                if (!messageOrBuilder.hasField(fieldDescriptor)) continue;
                Builder.findMissingFields((MessageOrBuilder)v, Builder.subMessagePrefix(string, fieldDescriptor, -1), list);
            }
        }

        private static String subMessagePrefix(String string, Descriptors.FieldDescriptor fieldDescriptor, int n) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (fieldDescriptor.isExtension()) {
                stringBuilder.append('(').append(fieldDescriptor.getFullName()).append(')');
            } else {
                stringBuilder.append(fieldDescriptor.getName());
            }
            if (n != -1) {
                stringBuilder.append('[').append(n).append(']');
            }
            stringBuilder.append('.');
            return stringBuilder.toString();
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString));
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream, extensionRegistryLite));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            return super.mergeDelimitedFrom(inputStream);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return super.mergeDelimitedFrom(inputStream, extensionRegistryLite);
        }
    }
}

