/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tv.samsung.vms.option;

import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.NetworkOption;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;

public class SNetworkOption
extends NetworkOption {
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        boolean isBridge = property.getPropertyValue().getAdvancedOptionValue("netConnectType").equals("Bridge");
        if (isBridge) {
            if (OSUtil.isWin()) {
                String tapName = property.getPropertyValue().getAdvancedOptionValue("netTapDevice");
                config.addQemuOption("-net", "tap,ifname=" + tapName + ",script=no,downscript=no");
            } else {
                config.addQemuOption("-net", "tap,script=/etc/emulator-ifup.sh,downscript=no");
            }
            config.addVariable(OPTION_KEY.VAR_MAC, this.getMacAddr(isBridge, property));
            config.addQemuOption("-net", "nic,model=virtio,macaddr=" + SNetworkOption.varForm((OPTION_KEY)OPTION_KEY.VAR_MAC));
        } else {
            config.addQemuOption("-net", "nic,model=virtio");
            config.addQemuOption("-net", "user");
        }
        config.addKernelOption(this.getIP(isBridge, property));
        String hostIP = property.getPropertyValue().getAdvancedOptionValue("hostIp");
        if (hostIP == null || hostIP.isEmpty()) {
            hostIP = this.getDefaultHostIP(isBridge, property);
        }
        config.addKernelOption("host_ip", hostIP, OPTION_KEY.VAR_HOST_IP);
    }
}

