/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tv.samsung.vms.option;

import java.io.File;
import java.io.IOException;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMCreatorException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class STunerOption
extends Option {
    public static final String TUNER_TEMPLATE_PATH = "tuner-template" + File.separator + "tuner_default_template.cfg";
    public static final String TABLE_DEFAULT = "tuner_default.cfg";

    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMCreatorException {
        File tunerFile;
        String tunerFilePath = property.getPropertyValue().getAdvancedSubOptionValue("tuner", "tunerFilePath");
        String tunerFileName = property.getPropertyValue().getAdvancedSubOptionValue("tuner", "tunerFileName");
        if (tunerFileName.equals(TABLE_DEFAULT) && tunerFilePath.isEmpty()) {
            tunerFilePath = FilePathResources.getTizenSDKDataVmsPath() + File.separator + property.getPropertyValue().vmName;
            tunerFile = new File(tunerFilePath + File.separator + tunerFileName);
            if (!tunerFile.exists()) {
                try {
                    File tunerTemplateFile = new File(property.getPropertyValue().getPlatform().getPlatformPath() + FilePathResources.getPlatformResourcesSuffix() + File.separator + TUNER_TEMPLATE_PATH);
                    HelperClass.FileCopy((File)tunerTemplateFile, (File)tunerFile);
                }
                catch (IOException e) {
                    EMLogger.getLogger().warning("Fail to copy default tuner file : " + tunerFile.getAbsolutePath());
                    EMLogger.getLogger().warning(e.getMessage());
                }
            }
        } else {
            tunerFile = new File(tunerFilePath + File.separator + tunerFileName);
            if (!tunerFile.exists()) {
                throw new VMCreatorException("Tuner table path is invalid or not exist.");
            }
        }
        String tunerCountry = property.getPropertyValue().getAdvancedSubOptionValue("tuner", "country");
        config.addVariableWithSpace(OPTION_KEY.VAR_TUNER_TABLE_PATH, tunerFilePath + File.separator + tunerFileName);
        String cmd = "";
        cmd = cmd + "maru-virtual-tuner,system=" + property.getPropertyValue().getAdvancedSubOptionValue("tuner", "system") + (tunerCountry == null || tunerCountry.isEmpty() ? "" : ",country=" + tunerCountry) + ",table=" + STunerOption.varForm((OPTION_KEY)OPTION_KEY.VAR_TUNER_TABLE_PATH) + ",stillimg=" + STunerOption.varForm((OPTION_KEY)OPTION_KEY.VAR_STILL_IMAGE_PATH) + ",wsi=" + STunerOption.varForm((OPTION_KEY)OPTION_KEY.VAR_WSI);
        config.addQemuOption("-device", cmd);
    }
}

