/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tv.samsung.vms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.NetworkProxy;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class RemoteLogger {
    private static final String SERVER_URL_FILE_PATH = "tools" + File.separator + "log-server.conf";
    private static final String DEFAULT_SERVER_URL = "https://samsungvdsdk.com";
    private static final String LOG_SCRIPT_PATH = "/cgi-bin/emulog.pl";
    private static final String URL_TITLE = "URL: ";
    private static final int LOG_SERVER_TIMEOUT = 3000;
    private static final String LOG_SCRIPT_URL = RemoteLogger.getLogScriptURL();
    private static long START_TIME = 0L;
    private static long STOP_TIME = 0L;
    private static boolean isSetProxy = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLogScriptURL() {
        String url = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(FilePathResources.getTizenSDKPath() + File.separator + SERVER_URL_FILE_PATH));
        }
        catch (FileNotFoundException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        if (br != null) {
            try {
                String sCurrentLine;
                while ((sCurrentLine = br.readLine()) != null) {
                    if (!sCurrentLine.startsWith(URL_TITLE)) continue;
                    url = new String(sCurrentLine.substring(URL_TITLE.length()));
                    int from = 0;
                    from = url.indexOf("//");
                    if ((from = url.indexOf(47, from + 2)) < 0) continue;
                    url = url.substring(0, from);
                }
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
                url = "";
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
            }
        }
        if (url.isEmpty()) {
            url = DEFAULT_SERVER_URL;
        }
        url = url + LOG_SCRIPT_PATH;
        EMLogger.getLogger().log(Level.INFO, "Logger URL : " + url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String msg) {
        if (msg == "start") {
            START_TIME = System.currentTimeMillis();
            return;
        }
        if (msg != "stop") return;
        RemoteLogger.setProxy();
        STOP_TIME = System.currentTimeMillis();
        InputStreamReader in = null;
        BufferedReader br = null;
        HttpURLConnection conn = null;
        if (LOG_SCRIPT_URL == "") return;
        try {
            String line;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            if (LOG_SCRIPT_URL.equals("")) {
                return;
            }
            URL url = new URL(LOG_SCRIPT_URL + "?d=" + RemoteLogger.getRuntimeDuration() + "&c=public");
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            StringBuffer sb = new StringBuffer();
            in = new InputStreamReader(conn.getInputStream());
            br = new BufferedReader(in);
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
                EMLogger.getLogger().log(Level.INFO, "get: " + line);
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (in != null) {
                    in.close();
                }
                if (conn == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
            START_TIME = 0L;
            STOP_TIME = 0L;
        }
    }

    public static int getRuntimeDuration() {
        int minute = 0;
        long duration = (STOP_TIME - START_TIME) / 1000L;
        minute = (int)(duration / 60L);
        return minute;
    }

    public static void setProxy() {
        String[] proxies;
        if (isSetProxy) {
            return;
        }
        String hostProxy = "";
        try {
            hostProxy = NetworkProxy.getHostProxy();
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        if (hostProxy.isEmpty()) {
            isSetProxy = true;
            return;
        }
        for (String proxy : proxies = hostProxy.split(" ")) {
            if (!proxy.startsWith("http")) continue;
            EMLogger.getLogger().fine(proxy);
            String proxy_value = proxy;
            proxy_value = proxy.substring(proxy.indexOf(61) + 1);
            String ip = proxy_value.substring(0, proxy_value.indexOf(58));
            String port = proxy_value.substring(proxy_value.indexOf(58) + 1);
            if (proxy.startsWith("https")) {
                System.setProperty("https.proxyHost", ip);
                System.setProperty("https.proxyPort", port);
                continue;
            }
            System.setProperty("http.proxyHost", ip);
            System.setProperty("http.proxyPort", port);
        }
        isSetProxy = true;
    }
}

