/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tv.samsung.vms.option;

import java.io.File;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.tv.samsung.vms.option.SOptionFactoryV2;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class SDefaultOption
extends Option {
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        config.addKernelOption("model", "4ksero");
        config.addQemuOption("-device virtio-maru-esm-pci");
        config.addQemuOption("-device virtio-maru-hwkey-pci");
        config.addQemuOption("-device virtio-maru-evdi-pci");
        config.addQemuOption("-device virtio-maru-motor-pci");
        config.addQemuOption("-device virtio-maru-keyboard-pci");
        config.addQemuOption("-rtc base=utc");
        config.addQemuOption("-M maru-x86-machine");
        config.addQemuOption("-soundhw all");
        config.addQemuOption("-usb");
        config.addQemuOption("-vga none");
        config.addVariableWithSpace(OPTION_KEY.VAR_STILL_IMAGE_PATH, SOptionFactoryV2.getStillImgPath(property));
        config.addVariable(OPTION_KEY.VAR_WSI, "vigs_wsi");
        config.addQemuOption("-device", "maru-external-input-pci,stillimg=" + SDefaultOption.varForm((OPTION_KEY)OPTION_KEY.VAR_STILL_IMAGE_PATH) + ",wsi=" + SDefaultOption.varForm((OPTION_KEY)OPTION_KEY.VAR_WSI));
        if (property.getPropertyValue().isHWVirtualization) {
            config.addKernelOption("yagl=1");
        }
        if (!OSUtil.isLinux() && property.getPropertyValue().isHWVirtualization) {
            config.addKernelOption("force_pat");
        }
        if (config.existVariable(OPTION_KEY.VAR_KERNEL)) {
            config.removeVariable(OPTION_KEY.VAR_KERNEL.toString());
        }
        String emulatorPath = property.getPropertyValue().getPlatform().getEmulatorDirPath();
        config.addVariableWithSpace(OPTION_KEY.VAR_KERNEL, emulatorPath + FilePathResources.getEmulatorKernelSuffix() + File.separator + "bzImage." + SDefaultOption.varForm((OPTION_KEY)OPTION_KEY.VAR_IMAGE_ARCH));
    }
}

