/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.simulator.standalone.launch;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.tizen.web.tv.sec.simulator.standalone.launch.Messages;

public abstract class LaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        IFile inputFile;
        IProject proj;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (proj = (inputFile = ((IFileEditorInput)input).getFile()).getProject()) != null) {
            try {
                if (proj.getNature("org.tizen.web.project.builder.WebNature") != null) {
                    this.launch(proj, mode);
                    return;
                }
            }
            catch (CoreException coreException) {}
            MessageDialog.openError((Shell)LaunchShortcut.getShell(), (String)Messages.LaunchShortcut_ErrorDialogTitle, (String)this.getIncompatibleProjectMessage());
            return;
        }
        MessageDialog.openError((Shell)LaunchShortcut.getShell(), (String)Messages.LaunchShortcut_ErrorDialogTitle, (String)this.getEditorEmptyMessage());
    }

    public void launch(ISelection selection, String mode) {
        IProject proj;
        IStructuredSelection sel;
        Object res;
        if (selection instanceof IStructuredSelection && (res = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IResource && (proj = ((IResource)res).getProject()) != null) {
            try {
                if (proj.getNature("org.tizen.web.project.builder.WebNature") != null) {
                    this.launch(proj, mode);
                    return;
                }
            }
            catch (CoreException coreException) {}
            MessageDialog.openError((Shell)LaunchShortcut.getShell(), (String)Messages.LaunchShortcut_ErrorDialogTitle, (String)this.getIncompatibleProjectMessage());
            return;
        }
        MessageDialog.openError((Shell)LaunchShortcut.getShell(), (String)Messages.LaunchShortcut_ErrorDialogTitle, (String)this.getSelectionEmptyMessage());
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(LaunchShortcut.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getConfigSelectionTitle());
        dialog.setMessage(Messages.LaunchShortcut_ChooseDialogMessage);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(IProject var1);

    protected ILaunchConfiguration findLaunchConfiguration(IProject project, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = this.getCandidateConfigs(project, configType);
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(project);
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected abstract List<ILaunchConfiguration> getCandidateConfigs(IProject var1, ILaunchConfigurationType var2);

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void launch(IProject project, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(project, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected String getEditorEmptyMessage() {
        return Messages.LaunchShortcut_EditableNotLaunchable;
    }

    protected String getSelectionEmptyMessage() {
        return Messages.LaunchShortcut_SelectionNotLaunchable;
    }

    protected String getConfigSelectionTitle() {
        return Messages.LaunchShortcut_ChooseDialogTitle;
    }

    protected String getIncompatibleProjectMessage() {
        return Messages.LaunchShortcut_IncompatibleProject;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

