/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.command;

import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.web.tv.sec.launch.command.ISdbCmd;

public class SdbCmdSelector {
    public PlatformCapability platformCapabilityChecker;
    public Object sdbCmdObj;
    private int wascmd = 0;
    private int pkgcmd = 1;
    private String version = null;
    private String arch = null;
    private float sdbPluginVersion;
    private int call = this.wascmd;

    public SdbCmdSelector(IDevice device) {
        String sdbPluginVer = null;
        try {
            this.version = device.getPlatformCapability().getPlatformVersion();
            this.arch = device.getPlatformCapability().getCpuArch();
            if (this.version.compareTo("4.0") == 0 && this.arch.contains("armv7") && !(sdbPluginVer = device.getPlatformCapability().getSdbdPluginVersion()).isEmpty()) {
                this.sdbPluginVersion = Float.valueOf(sdbPluginVer.substring(0, 3)).floatValue();
                if ((double)this.sdbPluginVersion < 3.4) {
                    this.call = this.pkgcmd;
                }
            }
        }
        catch (Exception exception) {
            this.call = this.pkgcmd;
        }
        try {
            this.platformCapabilityChecker = device.getPlatformCapability();
            if (this.platformCapabilityChecker.getSecureProtocol().equals("enabled")) {
                try {
                    Class<?> securityCmd = Class.forName(this.getSecureCmdClassName());
                    this.sdbCmdObj = securityCmd.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Class<?> nonSecurityCmd = Class.forName(this.getNonSecureCmdClassName());
                    this.sdbCmdObj = nonSecurityCmd.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            try {
                Class<?> nonSecurityCmd = Class.forName(this.getNonSecureCmdClassName());
                this.sdbCmdObj = nonSecurityCmd.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getCmd(String key, String param) {
        String cmd = "";
        String extension = "wgt";
        if (this.call == this.pkgcmd) {
            if (key.equals("VD_APPLIST_COMMAND")) {
                key = "QUERY_COMMAND";
            } else if (key.equals("VD_RUN_LAUNCH_COMMAND")) {
                key = "RUN_LAUNCH_COMMAND";
            } else if (key.equals("VD_UNINSTALL_COMMAND") || key.equals("VD_UNINSTALL_COMMAND_WITH_WASAPPID")) {
                key = "UNINSTALL_COMMAND";
            } else if (key.equals("INSTALL_COMMAND") || key.equals("INSTALL_COMMAND_2")) {
                int index = -1;
                String[] splitStr = param.split("\\.");
                index = splitStr.length - 1;
                if (index > 0 && (splitStr[index].equals("wgt") || splitStr[index].equals("tpk"))) {
                    extension = splitStr[index];
                }
                key = "INSTALL_COMMAND_3";
                param = String.valueOf(extension) + " tmp/" + param;
            } else if (key.equals("WAS_KILL_COMMAND")) {
                key = "KILL_COMMAND";
            }
        }
        ((ISdbCmd)this.getSdbCmdObj()).setPlatformCapabilityInstance(this.platformCapabilityChecker);
        cmd = ((ISdbCmd)this.getSdbCmdObj()).getCmd(key, param);
        return cmd;
    }

    public Object getSdbCmdObj() {
        return this.sdbCmdObj;
    }

    private String getSecureCmdClassName() {
        String secureCmdClassName = "";
        String productVer = this.platformCapabilityChecker.getProductVersion();
        String verText = productVer.replace(".", "_");
        secureCmdClassName = "SecureCmdVer" + verText;
        return "org.tizen.web.tv.sec.launch.command." + secureCmdClassName;
    }

    private String getNonSecureCmdClassName() {
        String nonSecureCmdClassName = "";
        String productVer = this.platformCapabilityChecker.getProductVersion();
        String verText = productVer.replace(".", "_");
        nonSecureCmdClassName = "NonSecureCmdVer" + verText;
        return "org.tizen.web.tv.sec.launch.command." + nonSecureCmdClassName;
    }

    public boolean isSecureProtocol() {
        try {
            return this.platformCapabilityChecker.getSecureProtocol().equals("enabled");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

