/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.CommonColor;
import org.tizen.common.ui.view.console.ConsoleManager2;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.dlog.DlogFormat;
import org.tizen.sdblib.dlog.DlogInfo;
import org.tizen.sdblib.receiver.DlogReceiver;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVDlogInfo;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVDlogTimeParser;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogInfo;

public class SecTVJsLogReceiver
extends DlogReceiver {
    protected ConsoleManager2 consoleManager;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String packageID = "";
    private String appID = "";
    private String servicePackageID = "";
    private int pid = 0;
    private boolean isClosed = false;
    private Calendar calendar;
    private String deviceBootTime;

    public SecTVJsLogReceiver(boolean pidMode) {
        this(0);
    }

    public SecTVJsLogReceiver() {
        this("", DlogFormat.TIME);
    }

    public SecTVJsLogReceiver(String packageID) {
        this(packageID, DlogFormat.TIME);
    }

    public SecTVJsLogReceiver(String packageID, DlogFormat dlogFormat) {
        super(dlogFormat);
        this.setTrimLines(false);
        this.setPackageID(packageID);
    }

    public SecTVJsLogReceiver(int pid) {
        this(pid, DlogFormat.BRIEF);
    }

    public SecTVJsLogReceiver(DlogFormat dlogFormat) {
        this(0, dlogFormat);
    }

    public SecTVJsLogReceiver(int pid, DlogFormat dlogFormat) {
        super(dlogFormat);
        this.setTrimLines(false);
        this.setPid(pid);
    }

    public void init() {
        this.isClosed = false;
    }

    public void setPackageID(String packageID) {
        this.packageID = packageID;
        this.logger.debug("Receiver's package id: {}", (Object)packageID);
    }

    public void setServicePackageID(String servicePackageID) {
        this.servicePackageID = servicePackageID;
        this.logger.debug("Receiver's service package id: {}", (Object)this.packageID);
    }

    public void setAppID(String appID) {
        this.appID = appID;
        this.logger.debug("Receiver's service package id: {}", (Object)this.packageID);
    }

    public String getPackageID() {
        return this.packageID;
    }

    public String getServicePackageID() {
        return this.servicePackageID;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setPid(int pid) {
        this.pid = pid;
        this.logger.debug("Receiver's pid: {}", (Object)pid);
    }

    public boolean isCancelled() {
        return this.isClosed;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public void setConsoleManager(ConsoleManager2 consoleManager) {
        this.consoleManager = consoleManager;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setDeviceBootTime(String clockTime) {
        String deviceBootTime = "0";
        double deviceBootTimeDouble = 0.0;
        long deviceBootTimeLong = 0L;
        Scanner sc1 = this.extracted(clockTime).useDelimiter(" ");
        deviceBootTime = sc1.next();
        deviceBootTimeDouble = Double.parseDouble(deviceBootTime);
        deviceBootTimeLong = Long.parseLong(String.valueOf(Math.round(deviceBootTimeDouble)));
        this.deviceBootTime = deviceBootTime = Long.toString(deviceBootTimeLong);
    }

    private Scanner extracted(String str) {
        return new Scanner(str);
    }

    public synchronized void processNewLines(String[] lines) {
        if (this.isClosed) {
            return;
        }
        this.logger.trace("Process new lines({})", (Object)lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.logger.trace("line: {}", (Object)line);
            ++n2;
        }
        this.printJsLog(this.parseJsLogForSecTV(lines));
    }

    protected void printJsLog(List<JsLogInfo> logMessageList) {
        if (this.consoleManager == null || logMessageList == null) {
            return;
        }
        for (JsLogInfo jsLogInfo : logMessageList) {
            LogLevel level = jsLogInfo.getDlogInfo().getLogLevel();
            if (level == null) continue;
            String consoleMessage = jsLogInfo.toString();
            if ('W' == level.getLetter()) {
                this.consoleManager.println(consoleMessage, 0, CommonColor.DARK_GOLDENROD);
                continue;
            }
            if ('E' == level.getLetter()) {
                this.consoleManager.println(consoleMessage, 0, CommonColor.RED);
                continue;
            }
            this.consoleManager.println(consoleMessage, 0, CommonColor.BLACK);
        }
        logMessageList.clear();
    }

    protected List<JsLogInfo> parseJsLogForSecTV(String[] lines) {
        if (lines == null) {
            return null;
        }
        ArrayList<JsLogInfo> jsLogInfos = null;
        SecTVDlogInfo[] dlogInfos = this.getDlogInfosForSecTV(this.getDlogFormat(), lines);
        if (dlogInfos == null) {
            this.logger.debug("Dlog's information list is null");
            return null;
        }
        jsLogInfos = this.pid != 0 ? this.getJSLogInfosByPID(dlogInfos) : this.getJSLogInfos(dlogInfos);
        return jsLogInfos;
    }

    public SecTVDlogInfo[] getDlogInfosForSecTV(DlogFormat format, String[] logs) {
        SecTVDlogTimeParser parser = new SecTVDlogTimeParser();
        SecTVDlogInfo[] infos = parser.parseForSecTV(logs);
        return infos;
    }

    private ArrayList<JsLogInfo> getJSLogInfosByPID(SecTVDlogInfo[] dlogInfos) {
        ArrayList<JsLogInfo> jsLogInfos = new ArrayList<JsLogInfo>();
        SecTVDlogInfo[] secTVDlogInfoArray = dlogInfos;
        int n = dlogInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JsLogInfo jsLogInfo;
            SecTVDlogInfo info = secTVDlogInfoArray[n2];
            if ((this.pid <= 0 || this.pid == info.getPid()) && (jsLogInfo = this.createJsLogInfoForSecTV(info)) != null) {
                jsLogInfos.add(jsLogInfo);
            }
            ++n2;
        }
        return jsLogInfos;
    }

    private ArrayList<JsLogInfo> getJSLogInfos(SecTVDlogInfo[] dlogInfos) {
        ArrayList<JsLogInfo> jsLogInfos = new ArrayList<JsLogInfo>();
        SecTVDlogInfo[] secTVDlogInfoArray = dlogInfos;
        int n = dlogInfos.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                JsLogInfo jsLogInfo;
                String pkgID;
                SecTVDlogInfo info;
                block5: {
                    info = secTVDlogInfoArray[n2];
                    pkgID = "";
                    try {
                        if (info.getCommand().contains(this.packageID)) {
                            pkgID = this.packageID;
                        }
                        long deviceBootTime = this.getDeviceBootTimeByLong();
                        long bootTimeOfDlog = this.getBootTimeOfDlog(info);
                        if (bootTimeOfDlog <= 0L || deviceBootTime <= bootTimeOfDlog) break block5;
                        break block6;
                    }
                    catch (Exception exception) {}
                }
                if ((this.packageID.equals("") || this.packageID.equals(pkgID)) && (jsLogInfo = this.createJsLogInfoForSecTV(info)) != null) {
                    jsLogInfos.add(jsLogInfo);
                }
            }
            ++n2;
        }
        return jsLogInfos;
    }

    public long getDeviceBootTimeByLong() {
        return Long.parseLong(this.getDeviceBootTime());
    }

    public String getDeviceBootTime() {
        return this.deviceBootTime;
    }

    private long getBootTimeOfDlog(SecTVDlogInfo info) {
        long bootTimeOfDlog = 0L;
        bootTimeOfDlog = info.getDeviceBootTime();
        return bootTimeOfDlog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsLogInfo createJsLogInfoForSecTV(SecTVDlogInfo info) {
        JsLogInfo jsLogInfo = new JsLogInfo((DlogInfo)info);
        String command = info.getCommand();
        if (command == null) {
            return jsLogInfo;
        }
        try {
            String[] path = StringUtil.split((String)command, (Pattern)Pattern.compile("(^.*?):(\\d*):(.*)"));
            if (path == null) {
                jsLogInfo.msg = command;
                return jsLogInfo;
            }
            URL url = new URL(command);
            if ("http".equals(url.getProtocol())) {
                if (path[2].contains("livereload.js")) {
                    return null;
                }
                jsLogInfo.sourceName = path[0];
                jsLogInfo.sourceName = StringUtil.split((String)jsLogInfo.sourceName, (String)"?")[0];
                if (jsLogInfo.sourceName.startsWith("/")) {
                    jsLogInfo.sourceName = jsLogInfo.sourceName.substring(1);
                }
            } else if ("file".equals(url.getProtocol())) {
                jsLogInfo.sourceName = this.getSourceName(path[0]);
            }
            jsLogInfo.line = path[1];
            jsLogInfo.msg = path[2];
            return jsLogInfo;
        }
        catch (MalformedURLException e) {
            jsLogInfo.msg = command;
            this.logger.debug(e.getMessage());
        }
        return jsLogInfo;
    }

    protected String getSourceName(String message) {
        if (StringUtil.isEmpty((CharSequence)message)) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        String[] temp = StringUtil.split((String)message, (String)"/");
        int i = 3;
        while (i < temp.length) {
            if ("res".equals(temp[i - 2]) && "wgt".equals(temp[i - 1])) {
                name.append(temp[i]);
            } else if (!StringUtil.isEmpty((CharSequence)name)) {
                name.append("/");
                name.append(temp[i]);
            }
            ++i;
        }
        return name.toString();
    }
}

