/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util.jsconsole;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.dlog.DlogFormat;
import org.tizen.web.tv.sec.launch.command.SdbCmdSelector;
import org.tizen.web.tv.sec.launch.util.jsconsole.SecTVJsLogReceiver;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

class SecTVJsLogThread
extends Thread {
    public static Logger logger = LoggerFactory.getLogger(SecTVJsLogThread.class);
    private IDevice device;
    private JsLogReceiver receiver;
    private SecTVJsLogReceiver secTVreceiver;
    private boolean isSecTVJsLogReceiverType = false;

    public SecTVJsLogThread(IDevice device, SecTVJsLogReceiver receiver) {
        super("SecTVJsLogThread");
        this.device = device;
        this.secTVreceiver = receiver;
        this.isSecTVJsLogReceiverType = true;
    }

    public SecTVJsLogThread(IDevice device, JsLogReceiver receiver) {
        super("SecTVJsLogThread");
        this.device = device;
        this.receiver = receiver;
        this.isSecTVJsLogReceiverType = false;
    }

    public void reStart() {
        if (this.isSecTVJsLogReceiverType) {
            this.secTVreceiver.init();
        } else {
            this.receiver.init();
        }
    }

    public void close() throws IOException {
        if (this.isSecTVJsLogReceiverType) {
            this.secTVreceiver.close();
        } else {
            this.receiver.close();
        }
    }

    public void setPackageID(String packageID) {
        if (this.isSecTVJsLogReceiverType) {
            this.secTVreceiver.setPackageID(packageID);
        } else {
            this.receiver.setPackageID(packageID);
        }
    }

    public String getPackageID() {
        return this.secTVreceiver.getPackageID();
    }

    public String getServicePackageID() {
        return this.secTVreceiver.getServicePackageID();
    }

    public String getAppID() {
        return this.secTVreceiver.getAppID();
    }

    @Override
    public void run() {
        try {
            DlogFormat dlogFormat = null;
            dlogFormat = DlogFormat.TIME;
            SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(ConnectionPlugin.getDefault().getCurrentDevice());
            String id = this.getServicePackageID();
            String cmd = null;
            if (id != null && !id.isEmpty()) {
                cmd = sdbCmdSelector.getCmd("SERVICE_DLOG_COMMAND", dlogFormat.getOption());
                cmd = String.valueOf(cmd) + " " + id + " " + this.getAppID();
            } else {
                cmd = sdbCmdSelector.getCmd("DLOG_COMMAND", dlogFormat.getOption());
            }
            if (this.isSecTVJsLogReceiverType) {
                this.secTVreceiver.init();
                this.secTVreceiver.setDlogFormat(dlogFormat);
                this.device.executeShellCommand(cmd, (IShellOutputReceiver)this.secTVreceiver, 2, "ls");
            } else {
                this.receiver.init();
                this.receiver.setDlogFormat(dlogFormat);
                this.device.executeShellCommand(cmd, (IShellOutputReceiver)this.receiver, 0);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

