/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.aoccompressor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.tizen.web.builder.ide.ISourceCompressor;

public class AocCompressor
implements ISourceCompressor {
    String projPath = "";
    String aocFolder = "aoc_app";

    public void compress(IProject project) throws Exception {
        System.out.println("compressing calling...");
        if (this.checkApp(project)) {
            System.out.println("Compressing source to wgt");
            String srcFolder = String.valueOf(this.projPath) + File.separator + this.aocFolder;
            final Path sourceDir = Paths.get(srcFolder, new String[0]);
            String zipFileName = srcFolder.concat(".zip");
            try {
                File zipFile = new File(zipFileName);
                if (zipFile.exists()) {
                    zipFile.delete();
                }
                final ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(zipFileName));
                Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                        try {
                            Path targetFile = sourceDir.relativize(file);
                            outputStream.putNextEntry(new ZipEntry(targetFile.toString()));
                            byte[] bytes = Files.readAllBytes(file);
                            outputStream.write(bytes, 0, bytes.length);
                            outputStream.closeEntry();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("AOC(" + this.aocFolder + ") folder not present");
        }
    }

    private boolean checkApp(IProject project) {
        String folder = project.getLocation().toFile().getPath().toString();
        String aocDir = String.valueOf(folder) + File.separator + this.aocFolder;
        System.out.println("aoc folder :: " + aocDir);
        this.projPath = folder;
        Path path = Paths.get(aocDir, new String[0]);
        boolean isDir = Files.isDirectory(path, new LinkOption[0]);
        if (isDir) {
            System.out.println("File is a Directory");
        } else {
            System.out.println("Directory doesn't exist!!");
        }
        return isDir;
    }
}

