/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.builder.toolchain;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.ExternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.web.tv.sec.wasm.builder.Messages;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.preferences.WasmPreferences;

public class WasmBuildRunner
extends ExternalBuildRunner {
    public static void symlinkOutput(IProject project, IConfiguration configuration) throws CoreException {
        String outputDir = configuration.getBuilder().getBuildLocation().toString();
        String projectDir = project.getLocation().toString();
        Path linkPath = Paths.get(projectDir, "CurrentBin");
        try {
            if (Files.isSymbolicLink(linkPath)) {
                Files.deleteIfExists(linkPath);
            } else {
                FileUtils.deleteQuietly((File)new File(linkPath.toString()));
            }
            Files.createSymbolicLink(linkPath, Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        }
        catch (SecurityException | UnsupportedOperationException | FileSystemException exception) {
            Logger.getLogger("org.tizen.web.tv.sec.wasm").warning("Failed to create symlink '" + linkPath.toString() + "' to '" + outputDir.toString() + "'. Fallback to copying output folder.");
            try {
                FileUtils.copyDirectory((File)new File(outputDir), (File)new File(linkPath.toString()));
            }
            catch (IOException exCopy) {
                Logger.getLogger("org.tizen.web.tv.sec.wasm").severe("Failed to copy outoput directory!");
                exCopy.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.wasm.builder", Messages.WasmBuildRunner_ErrorCreatingSymbolicLink, (Throwable)exCopy));
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.wasm.builder", Messages.WasmBuildRunner_ErrorCreatingSymbolicLink, (Throwable)ex));
        }
    }

    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        ProjectUtils.resetEmscriptenConfig((IProject)project, (IConfiguration)configuration, (String)WasmPreferences.getEmscriptenConfigPath((IProject)project), (String)WasmPreferences.getEmscriptenCachePath((IProject)project));
        boolean result = this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
        Path linkPath = Paths.get(project.getLocation().toString(), "CurrentBin");
        if (kind != 15 || !Files.isSymbolicLink(linkPath)) {
            WasmBuildRunner.symlinkOutput(project, configuration);
        }
        project.refreshLocal(2, monitor);
        return result;
    }
}

