/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.step;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.tv.sec.launch.command.SdbCmdSelector;
import org.tizen.web.tv.sec.launch.step.SecTVKillStep;

public class SecTVKillForDebugStep
extends SecTVKillStep {
    protected static final Logger logger = LoggerFactory.getLogger(SecTVKillForDebugStep.class);
    protected StringBuffer result;

    @Override
    protected String getLaunchCommand() throws Exception {
        SdbCmdSelector sdbCmdSelector = new SdbCmdSelector(ConnectionPlugin.getDefault().getCurrentDevice());
        String cmd = sdbCmdSelector.getCmd("ALL_KILL_COMMAND_FOR_DEBUG", null);
        return cmd;
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.killAllAppOfWorkspace();
    }

    private void killAllAppOfWorkspace() {
        String killCmd = "";
        try {
            killCmd = this.getLaunchCommand();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> webProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isWebProject((IProject)project)) {
                webProjects.add(project);
            }
            ++n2;
        }
        for (IProject webProject : webProjects) {
            String appPKGName = "";
            ITizenConfigurator configurator = null;
            try {
                configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)webProject);
            }
            catch (ConfigurationException ex) {
                ex.printStackTrace();
            }
            appPKGName = configurator.getApplicationPackage();
            this.killApp(killCmd, appPKGName);
        }
    }

    public MultiLineReceiver createMultiLineReceiver() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String content = stringArray[n2];
                    SecTVKillForDebugStep.this.setResult(String.valueOf(content) + System.getProperty("line.separator"));
                    ++n2;
                }
            }
        };
    }

    public void setResult(String result) {
        if (this.result == null) {
            this.result = new StringBuffer();
        }
    }

    public void clearResult() {
        if (this.result == null) {
            this.result = new StringBuffer();
        } else {
            this.result.delete(0, this.result.capacity());
            this.result.setLength(0);
        }
    }

    private void killApp(String cmd, String packageID) {
        try {
            cmd = String.valueOf(cmd) + " " + packageID;
            MultiLineReceiver receiver = null;
            receiver = this.createMultiLineReceiver();
            ConnectionPlugin.getDefault().getCurrentDevice().executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

