/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.launch.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.web.tv.sec.launch.WASAppInfo;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class SecTVCommandLauncher
extends CommandLauncher {
    SecTVWRTCommandUtil secTVWRTCommandUtil = new SecTVWRTCommandUtil();
    ZimLaunchResource zimLaunchResource;

    public SecTVCommandLauncher() throws NoConnectedDeviceException {
        this(ConnectionPlugin.getDefault().getCurrentDevice());
    }

    public SecTVCommandLauncher(IDevice device) throws NoConnectedDeviceException {
        this(device, 300);
    }

    public SecTVCommandLauncher(IDevice device, int timeout) throws NoConnectedDeviceException {
        this.device = device != null ? device : ConnectionPlugin.getDefault().getCurrentDevice();
        this.timeout = Math.max(90, timeout);
    }

    public boolean isInstalled(ZimLaunchResource resource) throws Exception {
        this.zimLaunchResource = resource;
        boolean isInstalled = false;
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
        boolean sameOrBiggerThanVersion3 = version.isSameOrBiggerThanVersion3();
        String pkgId = sameOrBiggerThanVersion3 ? "'" + resource.getAppinfo().getAppID() + "'" : resource.getAppinfo().getAppPackageID();
        if (StringUtil.isEmpty((CharSequence)pkgId)) {
            return isInstalled;
        }
        String cmd = this.getCommand("QUERY_COMMAND", resource);
        if (sameOrBiggerThanVersion3 && this.device.getPlatformCapability().getSecureProtocol().equals("disabled")) {
            cmd = cmd.replaceFirst("wrt-", "app_");
        }
        this.runCommand(cmd, false);
        String delim = String.valueOf(System.getProperty("line.separator")) + " ";
        String[] stringArray = StringUtil.split((String)this.getResultString(), (String)delim);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String widget = stringArray[n2];
            if (ObjectUtil.equals((Object)pkgId, (Object)widget)) {
                isInstalled = true;
                break;
            }
            ++n2;
        }
        return isInstalled;
    }

    public WASAppInfo isInstalledWAS(ZimLaunchResource resource) throws Exception {
        String[] lines;
        WASAppInfo wasAppInfo = null;
        this.zimLaunchResource = resource;
        boolean isInstalled = false;
        String appId = resource.getAppinfo().getAppID();
        if (StringUtil.isEmpty((CharSequence)appId)) {
            isInstalled = false;
            return wasAppInfo;
        }
        String cmd = this.getCommand("VD_APPLIST_COMMAND", resource);
        this.runCommand(cmd, false);
        String delim = System.getProperty("line.separator");
        String[] stringArray = lines = StringUtil.split((String)this.getResultString(), (String)delim);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String logMsg = stringArray[n2];
            if (logMsg.matches(".*" + appId + ".*")) {
                isInstalled = true;
                break;
            }
            ++n2;
        }
        if (isInstalled) {
            wasAppInfo = this.getWASAppInfo(lines, appId);
        }
        return wasAppInfo;
    }

    public WASAppInfo getWASAppInfo(String[] lines, String targetTizenAppID) {
        WASAppInfo wasAppInfo = new WASAppInfo();
        String wasAppID = "";
        String appName = "";
        String appVersion = "";
        String tizenAppID = "";
        int matcherFindNumber = 0;
        String regx = "(app_id|app_title|app_version|app_tizen_id|version|tizen_id)(.*)=(.*)";
        Pattern pattern = Pattern.compile(regx);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String cont = stringArray[n2];
            Matcher matcher = pattern.matcher(cont);
            String value = "";
            while (matcher.find()) {
                String lineText = matcher.group(1);
                value = matcher.group(3).replaceAll("-", "").trim();
                if (lineText.contains("app_id")) {
                    wasAppID = value;
                } else if (lineText.contains("app_title")) {
                    appName = value;
                } else if (lineText.contains("app_version") || lineText.contains("version")) {
                    appVersion = value;
                } else if (lineText.contains("app_tizen_id") || lineText.contains("tizen_id")) {
                    tizenAppID = value;
                }
                ++matcherFindNumber;
            }
            if (matcherFindNumber == 4) {
                wasAppInfo.setAppName(appName.trim());
                wasAppInfo.setAppVersion(appVersion.trim());
                wasAppInfo.setWasAppID(wasAppID.trim());
                wasAppInfo.setTizenAppID(tizenAppID.trim());
                matcherFindNumber = 0;
                if (tizenAppID.equals(targetTizenAppID)) break;
            }
            ++n2;
        }
        return wasAppInfo;
    }

    public boolean isRunningWidget(ZimLaunchResource resource) throws Exception {
        Object[] results;
        this.zimLaunchResource = resource;
        boolean isRunning = false;
        String appPkgId = resource.getAppinfo().getAppPackageID();
        if (StringUtil.isEmpty((CharSequence)appPkgId)) {
            return isRunning;
        }
        String cmd = this.getCommand("RUN_CHECK_COMMAND_1", resource);
        int code = this.runCommand(cmd, true);
        if (code == 0) {
            isRunning = true;
        }
        if (ArrayUtil.isEmpty((Object[])(results = this.getResultLineStrings()))) {
            return false;
        }
        Object[] objectArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            Object result = objectArray[n2];
            isRunning = ((String)result).endsWith("is Running");
            if (isRunning) break;
            ++n2;
        }
        if (code != 0) {
            isRunning = false;
        }
        return isRunning;
    }

    public String getCommand(String key, ZimLaunchResource resource) throws Exception {
        this.zimLaunchResource = resource;
        return this.secTVWRTCommandUtil.getCommand(key, null, resource);
    }

    public String getCheckTempDirCommand(String dirCmdOutput) {
        String cmd = null;
        try {
            cmd = this.secTVWRTCommandUtil.getCommand("MK_DIR_COMMAND_1", dirCmdOutput, this.zimLaunchResource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    public String getCreateCmdOutputMessageFileDirCommand(String dirCmdOutput) {
        String cmd = null;
        try {
            cmd = this.secTVWRTCommandUtil.getCommand("MK_DIR_COMMAND_2", dirCmdOutput, this.zimLaunchResource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    protected boolean checkWRTType(String wrtCommand) throws Exception {
        String cmd = this.getCommand("WRT_CHECK_COMMAND_2", this.zimLaunchResource);
        int code = this.runCommand(cmd, true);
        return code == 0;
    }
}

