var _ = require('lodash');
var pkg = require('../package.json');
var path = require('path');
var localConfig;

try{
    localConfig = require(path.join(__dirname,'../config.json'));
}catch(e){
    console.warn("[MultiScreen] No service config found! ... using default");
}

var configuration = {

    allowAllContent : false,

    logging : {

        level : 'error',
        handleExceptions : true,
        exitOnError : false
    },

    service : {
        version     : pkg.version,
        port        : '8001',
        apiVersion  : '2.0'

    },

    plugins : {}
};

if(localConfig){
    _.merge(configuration, localConfig);
}

console.info("[MultiScreen] config : ", configuration);

module.exports = configuration;