var _ = require('lodash');
var request = require('request');
var uuid = require('node-uuid');
var util = require('util');
var MSFPlugin = require('../plugin');
var express = require('express');


var URL_BEACON = 'http://multiscreen.samsung.com/analyticsservice/v1/collect/events';
var APP_TYPE_INSTALLED = 1;
var APP_TYPE_WEB = 2;
var WEBLAUNCHER_ID = 'MSF-WEBLAUNCHER';


function Analytics(config){

	/*
    Call the Super
	 */
	MSFPlugin.apply(this, arguments);

	var self = this;
	var service 		 = this.service;
	var device 			 = this.device;
	var serviceSessionID = uuid.v1();

	/*
	 Formulates tracking data object and post to analytics service
	 */
	var track = this.track = function(eventType, trackingPayload){

		// Clone so that we don't affect the original data
		trackingPayload = _.merge({},trackingPayload);
		trackingPayload = trackingPayload || {};
		trackingPayload.type = eventType;
		trackingPayload.serviceSessionID = serviceSessionID;

		_.each(device.attributes, function(val,key){
			trackingPayload['device_' + key] = val;
		});

		request.post(URL_BEACON, {json:trackingPayload}, function(error){
			if (!error){
				self.logger.silly('tracking sent : ', trackingPayload);
			} else {
				self.logger.error('tracking NOT sent : ', trackingPayload, error);
			}

		});
	};

	/*
	 Service event listeners
	 */
    service.events.on('channel:session:end', function(session){
        track('channelSession', session);
    });

    service.events.on('channel:client:session:end', function(session){
		track('clientSession', session);
	});


	/*
	 Device event listeners
	 */
    device.on('ready', function(){
        track('serviceStart');
    });

    device.on('launchApplication', function(opts){
		track('launchApplication', _.extend(_.omit(opts, 'id', 'data'), {appID: opts.id, appType: APP_TYPE_INSTALLED}));
	});

    device.on('terminateApplication', function(opts){
		track('terminateApplication',  _.extend(_.omit(opts, 'id'), {appID: opts.id, appType: APP_TYPE_INSTALLED}));
	});

	device.on('launchWebApplication', function(opts){
		track('launchApplication', _.extend(_.omit(opts, 'id', 'data'), {appID: WEBLAUNCHER_ID, appType: APP_TYPE_WEB}));
	});

	device.on('terminateWebApplication', function(opts){
		track('terminateApplication',  _.extend(_.omit(opts, 'id'), {appID: WEBLAUNCHER_ID, appType: APP_TYPE_WEB}));
	});

    device.on('installApplication', function(opts){
		track('installApplication',  _.extend(_.omit(opts, 'id'), {appID: opts.id}));
	});


	/*
	 Attempt to send a end event on process exit
	 */
	process.on('exit', function(){
		track('serviceEnd');
	});

}

MSFPlugin.extend(Analytics);


module.exports = Analytics;
