var Channel = require("./Channel");

var channels = {};


function createChannel(id){

    var self = this;    

    if(!channels[id]){
        var channel = channels[id] = new Channel(id);

        // If the server shutsDown remove it from the mapped channels
        channel.on("shutDown", function(){
            self.removeChannel(id);
        });

        return channels[id];

    }else{
        return false;
    }
}

function removeChannel(id){    

    if(channels[id]){
        delete channels[id];
        channels[id] = void 0;
        return true;
    }else{
        return false;
    }
}

function getChannel(id){    

    if(channels[id]){
        return channels[id];
    }else{
        return false;
    }
}


module.exports.createChannel = createChannel;
module.exports.removeChannel = removeChannel;
module.exports.getChannel = getChannel;
