var util = require('util');
var _ = require('lodash');
var winston = require('winston');
var EventEmitter = require('eventemitter2').EventEmitter2;
var service = require('../lib/multiscreen-service');

function MSFPlugin(config){

    // Set all plugins to be event emitters
    EventEmitter.call(this);

    // Properties available to all plugins
    this.name       = this.constructor.name;
    this.config     = _.defaults(config || {}, this.configDefaults || {});
    this.service    = service;
    this.app        = service.app;
    this.server     = service.server;
    this.device     = service.device;
    this.utils      = service.utils;
    this.logger     = service.logger.createNamedLogger('Plugin : '+this.name);

    this.logger.info('Loaded');
}

MSFPlugin.extend = function(targetClass){
    util.inherits(targetClass, MSFPlugin);
};

util.inherits(MSFPlugin, EventEmitter);

module.exports = MSFPlugin;