var AdmZip = require('adm-zip'),
	os = require('os'),
    path = require('path'),  
    fs = require('fs'),
    _xml2js = require('xml2js'),
    info = null,
    tmpDirectory = (process.cwd()).replace(/\\/g,'/') + '/appLauncher/tmp/',
    installDirectory = (process.cwd()).replace(/\\/g,'/') +  '/appLauncher/app/',
	cmd,
	appData,
	bInit = false,
	intervalHandle = null;

process.on('message', function(m){
	if(!bInit){
		bInit = true;
	}
	cmd = m.cmd,
    appInfo = m.arg;
	appData = m.appData;

	switch (cmd) {
		case 'install.wgt':
			_handleWgtInstall(appInfo);
			break;
			
		case 'install.html':
		    _handleHtmlInstall(appInfo);
		    break;
		    
		default:
		   // do nothing
	}
});

function _handleWgtInstall(appInfo){
	try{
		_checkConfig(appInfo.path, appInfo.name);

		var orgPath = appInfo.path,
		    destPath = installDirectory + info.package + '/';
		
        if(fs.existsSync(destPath)){
        	removeFolder(destPath);
		}

		try{
			_uncompressWgt(orgPath, destPath);
		}
		catch(e){
			var text = _reducePath(orgPath, 20) + ' is bad, please check it.',
			    tip = orgPath + ' is bad, please check it.';
		
			throw {
				message: text,
				tip: tip
			};
		}

		//process.send({ sucess: true, cmd: cmd, operation: 'UNZIPDONE', path: destPath });
		process.send({ sucess: true, cmd: cmd, operation: 'UNZIPDONE', path: destPath, bNacl: info.bNacl});
	}
	catch(e){
		process.send({ 
			sucess: false,
			message: e.message,
            tip: e.tip || e.message
        });
	}
}

function _handleHtmlInstall(appInfo){
	try{
		_checkConfig(appInfo.path, appInfo.name);

		if(!fs.existsSync(installDirectory)){
			fs.mkdirSync(installDirectory);
		}
		var orgPath = path.dirname(appInfo.path),
			destPath = installDirectory + info.package + '/';
		if(fs.existsSync(destPath)){
			removeFolder(destPath);
		}
		fs.mkdirSync(destPath);
		_copySync(orgPath, destPath);
		//process.send({ sucess: true, cmd: cmd, operation: 'COPYDONE', path: destPath, packageId: info.package});
		process.send({ sucess: true, cmd: cmd, operation: 'COPYDONE', path: destPath, htmlname: appInfo.name, packageId: info.package, bNacl: info.bNacl});
	}
	catch(e){
		process.send({
			sucess: false,
            message: e.message,
            tip: e.tip || e.message
		});
	}
}

function  _uncompressWgt(originPath, destPath){
	var zip = new AdmZip(originPath);
	zip.extractAllTo(destPath,true);
}

function _copySync(src, dst){
	var MAX = 5 * 1024;
	var dirList = fs.readdirSync(src);
	dirList.forEach(function(folder){
		var srcPath = src + '/' + folder,
		    dstPath = dst + '/' + folder,
		    stat = fs.statSync(srcPath);
		    
	    if(stat.isDirectory())
	    {
	    	fs.mkdirSync(dstPath);
			_copySync(srcPath, dstPath);
	    }
	    else if(stat.isFile()){
	    	var fdread = fs.openSync(srcPath, 'r'),
	    	    fdwrite = fs.openSync(dstPath, 'w', 438),
	    	    len = stat.size,
	            buffer = new Buffer(MAX),
	            position = 0,
	            readNumber = 0,
	            writeNumber = 0;
	        
	        while(len){
	        	if(len < MAX){
	        		readNumber = fs.readSync(fdread, buffer, 0, len, position);
	        		
	        	}else{
	        		readNumber = fs.readSync(fdread, buffer, 0, MAX, position);
	        	}
	        	writeNumber = fs.writeSync(fdwrite, buffer, 0, readNumber, position);
	        	len = len - writeNumber;
	        	position = position + writeNumber;
	        }
	        
	        fs.closeSync(fdread);
	        fs.closeSync(fdwrite);
	    }
	});
}

// '/' should be the end of path
function _findSync(path, str){
	var dirList = fs.readdirSync(path);

	var dirLen = dirList.length;
	for(var i = 0; i < dirLen; i++)
	{
		var item = dirList[i];
		
		var srcPath = path + item,
			stat = fs.statSync(srcPath);
		    
	    if(stat.isDirectory())
	    {
			if (true === _findSync(srcPath + '/', str))
			{
				return true;
			}
	    }
	    else if(stat.isFile()){
			if (item.indexOf(str) !== -1)
			{
				return true;
			}
	    }
	}

	return false;
}

function _getNaclFlag(path){
	return _findSync(path, '.nexe');
}
function _checkConfig(path, name){
	var cPath,
		dPath,
	    bWgt = false;

    if(path.indexOf('.wgt') > -1){
    	bWgt = true;
		var wgtName = require('path').basename(path, '.wgt');
		var appPath = (process.cwd()).replace(/\\/g,'/')+ '/appLauncher/tmp/';
		
		if(!fs.existsSync(tmpDirectory)){  
			fs.mkdirSync(tmpDirectory);
		}
		
		if(!fs.existsSync(installDirectory)){  
			fs.mkdirSync(installDirectory);
		}

		var destPath = (process.cwd()).replace(/\\/g,'/') + '/appLauncher/tmp/'+ wgtName + '/';
		dPath = destPath;

	    try{
	    	_uncompressWgt(path, destPath);
	    } catch(e) {
	    	throw {
	    		message: name + ' is bad, please check it.'
	    	};
	    }
		cPath = destPath + 'config.xml';
    }else if(path.indexOf('.html') > -1){
    	var tmpPath = path.replace(/\\/g,'/'),
    	    index = tmpPath.lastIndexOf('/');

    	path = path.substring(0, index + 1);
		path += 'config.xml';
		if(isWin()){
			cPath = path.replace(/file:\/{2,}/,'');
		}else{
			cPath = path.replace(/file:\/{2}/,'');
		}
    }else{
    	throw {
	    	message: 'Please use wgt or html file'
	    };
    }

    if(!fs.existsSync(cPath)){
    	var text = 'File ' + _reducePath(cPath, 25) + ' does not exist.',
    	    tip = 'File ' + cPath + ' does not exist.';

    	throw {
	    	message: text,
	    	tip: tip
	    };
    }
	
    info = _getConfigInfo(cPath);
    if(true == bWgt){
    	try{
            removeFolder(dPath);
    	}
    	catch(e){
    		// what should do?
    	}
    }

    return _validateConfig(info, name);
}

function _getConfigInfo(path){
	var res = {};
	res.id = null;
	res.package = null;
	var xmlParser = new _xml2js.Parser();
	var content = fs.readFileSync(path);
	try{
		xmlParser.parseString(content, function(error, result){
			if(result.widget){
				res.id = result.widget['tizen:application'][0]['$'].id;
				res.package = result.widget['tizen:application'][0]['$'].package;
				var name = result.widget.name;
			    if(name){
					if(typeof name[0] != 'string'){
						res.name = name[0]._ || '';
					}else{
					  	res.name = name[0];
					}
			    }else{
			    	res.name = '';
			    }

				// set nacl flag
				var appPath = path.substring(0, path.length - 10);
				res.bNacl = _getNaclFlag(appPath);
			}  
		});
	}
	catch(e){
		bInstalling = false;
		throw {
	    	message: 'config.xml file is bad.'
	    };
	}

	return res;
}

function _validateConfig(res, name){
	if(_validateId(res.id) && _validatePackage(res.package)){
		var data = appData,
			installedList = data.installedList;
		if(data != 'null' && data != undefined && data.installedList != undefined){
			var bRes = true,
				id,
				appName,
				path;
			for(item in installedList){
				id = installedList[item].id;
				path = installedList[item].path;
				appName = installedList[item].name;
				if(res.package == id && res.name == appName){
					path = decodeURI(path);
					if(process.platform == 'win32'){
						path = path.replace(/\\/g,'/'); 
					}
					if(isWin()){
						path = path.replace(/\\/g,'/');
						path = path.replace(/file:\/{2,}/,'');
					}else{
						path = path.replace(/file:\/{2}/,'');
					}
					try{
						removeFolder(path);
					}
					catch(e){
					    // what should do?	
					}
				}
				
				if(res.package == id && res.name != appName){
					bInstalling = false;

					throw {
	    				message: 'Please don\'t change name of package.'
	    			};
				}
			}
		}
		return bRes;
	} else if(!_validateId(res.id) && _validatePackage(res.package)){

		throw {
	    	message: 'Please don\'t change name of package.'
	    };
	} else if(_validateId(res.id) && !_validatePackage(res.package)){

		throw {
	    	message: 'Please don\'t change name of package.'
	    };
	}
	else if(!_validateId(res.id) && !_validatePackage(res.package)){

		throw {
	    	message: 'Please don\'t change name of package.'
	    };
	}
	return false;
}

function _validateId(id){
 	if(id != '' && id != undefined && id != null){
 		return true;
 	}
 	
 	return false;
}

function _validatePackage(package){
	if(package != '' && package != undefined && package != null){
 		return true;
 	}
 	
 	return false;
}

function _reducePath(path, max){
    path = path.replace(/\\/g,'/');
    var text = '';
	if(path){
		var len = path.length;
		if(max >= len){
			text = path;
		}else{
			var split = path.split('/');
				splitLen = split.length;
				arrayLen = [];
			for(var i = 0; i <= splitLen - 1; i++){
				arrayLen.push(split[i].length);
			}
			
			if(1 === splitLen){
				text = path;
			}else if(2 === splitLen){
				if((max - 6) >= arrayLen[1]){
					text = split[0].substring(0, 2) + '...' + split[1];
				}else{
					text = path;
				}
			}else if(3 <= splitLen){
				if((max - 5) >= arrayLen[splitLen - 1]){
					var addLen = 0,
					    leftLen = max - arrayLen[splitLen - 1] - 3;
					for(var i = 0; i <= splitLen - 1; i++){
						addLen = addLen + arrayLen[i] + 1;
						if(addLen < leftLen){
							text = text + split[i] + '/';
						}else{
							if(0 === i){
								text = split[0] + '/.../' + split[splitLen - 1];
							}else{
								text = text + '.../' + split[splitLen - 1];
							}
							break;
						}
					}
				}else{
					text = path;
				}
			}
		}
	}

	return text;
}

function isWin(){
	var _platform = os.platform().toLowerCase();
	return _platform.indexOf('win') >= 0 && _platform.indexOf('darwin') == -1;
}

function removeFolder(path) {
    var files = [];
    if(fs.existsSync(path)) {
        files = fs.readdirSync(path);
        files.forEach(function(file,index){
			var curPath = path + '/' + file;
	   	   	if(fs.statSync(curPath).isDirectory()) { 
				removeFolder(curPath);
	   	   	} else { 
	           	fs.unlinkSync(curPath);
			}
        });
        fs.rmdirSync(path);
    }
}

intervalHandle = setInterval(function(){
	if(bInit){
		clearInterval(intervalHandle);
	}else{
		process.send({ sucess: true, cmd: 'process.init', operation: 'INITDONE' });
	}
}, 50);