This is a middleware to send files with a user-defined mime type.

## Usage

The `express-custom-mime-types` package is simply a function, which accepts one parameter: `options`.

So far, `options` accepts one property: `mimes`. `mimes` is an associative array.

Each property of the associative array represents the file extension with the value being the mime-type.

In the following example, we have our express.js app serve `*.underscore` files as plain text.

```javascript
var express = require('express');
var app = express();
app.configure(function () {
  // ...
  app.use(require('express-custom-mime-types')({
    mimes: {
      '.underscore': 'text/plain'
    }
  }));
  // ...
});
```