var utils = require('../utils');
var path = require("path");
var fs = require("fs");
var logger = require('../logging/index').createNamedLogger('Settings');

var settingsPath = path.join(__dirname,'../../../.settings.json');
var _data;

var settings = {

    get data(){

        if(_data) {
            return _data;
        }else if(fs.existsSync(settingsPath)){
            try{
                logger.info('Loading settings from '+settingsPath);
                _data = require(settingsPath);
            }catch(e){
                logger.warn('Unable to load settings : ', e.message);
                _data = {};
            }
            return _data;
        }else{
            logger.info('No settings file detected, creating...');
            _data = {};
            this.save();
            return _data;
        }


    },

    save : function(){
        try{
            fs.writeFileSync(settingsPath, JSON.stringify(_data,null,4));
            logger.info('Settings saved to disk at '+settingsPath);
        }catch(e){
            logger.error('Unable to write settings to disk. Settings will not persist after this session : ', e.message);
        }
    }

};

module.exports = settings;
