var _ = require('lodash');
var util = require('util');
var request = require('request');
var MSFPlugin = require('../plugin');

/*
 Constants
*/
var URI_SERVICE = 'https://multiscreen.samsung.com/discoveryservice/v2/devices';


function CloudDiscoveryV2(config){

	/*
    Call the BaseModule constructor
	 */
    MSFPlugin.apply(this, arguments);

    /*
     Device event handlers
     */
    this.device.on('change',this.update.bind(this));
    this.device.on('ready', this.update.bind(this));

}

MSFPlugin.extend(CloudDiscoveryV2);



/*
 Regenerates and updates the services reservation in the cloud
 */
CloudDiscoveryV2.prototype.update = function(){

    var reservation = {
        "duid": this.device.attributes.duid,
        "serviceUri": "http://"+this.utils.getInternalIP()+":8001/api/v2/",
        "version": "2"
    };

    this.logger.info('updating reservation to : ', reservation);

	request.post(URI_SERVICE, {json : reservation}, function(error, response, body){
        if(error){
            this.logger.error(error.message);
        }else if(response.statusCode !== 200){
            this.logger.warn('update response : http error status of '+response.statusCode);
        }else if(!body || !body.ttl){
            this.logger.warn('update response : no ttl in response ', response.body);
        }else{
            this.logger.info('update response : ', response.body);
            var nextUpdate = (response.body.ttl/2) * 1000;
            setTimeout(this.update.bind(this), nextUpdate);
        }

    }.bind(this));
};

module.exports = CloudDiscoveryV2;
