var _ = require('lodash');
var fs = require('fs');
var os = require('os');
var path = require('path');
var MSFPlugin = require('../plugin');
var url = require('url');

// TODO : Remove this path dependency
var WebSocketServer = require('../../lib/ws').Server;

/*
 Constants
 */
var URI_ROOT = '/';
var URI_LOGS = '/logs/';
var URI_SETTINGS_UPDATE = '/settings';

/*
 HTML Templates
 */
var indexTemplate = require.resolve('./templates/index.tpl');


/*
 The websocket log server is only created if someone views the logging page to reduce resources
 */
var wsLogServer;



function DevTools(config){

    /*
     Call the BaseModule constructor
     */
    MSFPlugin.apply(this, arguments);

    /*
     Route Handlers
     */
    this.app.get(URI_ROOT, this.renderIndex.bind(this));
    this.app.post(URI_SETTINGS_UPDATE, this.updateSettings.bind(this));
    this.app.get(URI_LOGS, this.renderLogs.bind(this));

}

MSFPlugin.extend(DevTools);

/*
 Creates and sets up the websocket server to broadcast logging messages
 */
DevTools.prototype.createWebSocketServer = function(){

    if(!wsLogServer){

        var self = this;

        this.logger.info('Starting websocket logging server');

        wsLogServer = new WebSocketServer({server:this.server, path:'/logger'});

        wsLogServer.broadcast = function(data) {
            for(var i=0; i<this.clients.length; i++){
                this.clients[i].send(data);
            }
        };

        wsLogServer.on('connection', function(ws) {
            self.logger.info('Client connected to log server....');
        });

        this.service.logger.addListener('logging', function(transport, level, msg, meta){

            // Only log the console transport to keep from broadcasting multiple times for a single message
            if(transport.name === 'console'){
                var entry = { level : level, msg : msg, meta : meta};
                // Wrap in a try catch in case the meta has a circular reference
                try{
                    entry = JSON.stringify(entry);
                    wsLogServer.broadcast(entry);
                }catch(e){
                    console.error(e);
                }

            }

        });

    }

};

DevTools.prototype.renderIndex = function(req, res, next){

    var tplIndex = _.template(fs.readFileSync(indexTemplate,'utf8'));

    var content = tplIndex({
        mem     : process.memoryUsage(),
        service : this.service.config.service,
        logging : {
            level : this.service.logger.level,
            levels : ["error","warn","info","verbose","debug", "silly"]
        },
        allowAllContent : this.device.allowAllContent,
        device  : this.service.device.attributes
    });


    res.set('Content-Type', 'text/html');
    res.end(content);

};


DevTools.prototype.updateSettings = function(req, res, next){

    /* Verify this was not sent by a foreign referrer */
    var ref = req.get('referrer');
    var host = url.parse(ref).hostname;
    if(this.utils.isInternalIp(host) || host === 'localhost'){

        var message = 'Settings updated!';
        if(req.body.logLevel){
            this.service.logger.setLogLevel(req.body.logLevel);
            message = 'Log level updated to '+ req.body.logLevel;
        }
        if(req.body.allowAllContent){
            this.device.allowAllContent = (req.body.allowAllContent === 'true');
            message = 'Allow all content set to '+ this.device.allowAllContent;
        }
        this.logger.info(message);
        res.send(message);

    }else{
        res.send(403,'Not Allowed');
    }



};

DevTools.prototype.renderLogs = function(req, res, next){
    if(!wsLogServer) this.createWebSocketServer();
    res.sendfile(path.join(__dirname,'./templates/logs.html'));

};


module.exports = DevTools;