/*
	This plugin is only needed so that mobile web applications can use the DIAL API
	TODO : Work with VD so that the DIAL team adds cross origin access, so we can remove this plugin
*/

var _ = require('lodash');
var util = require('util');
var fs = require('fs');
var path = require('path');
var request = require('request');
var url = require('url');
var MSFPlugin = require('../plugin');

/*
 Constants
 */
var URI_ROOT = '/ws/apps/';
var PORT 	 = '8080';


/*
HTML Templates
*/
var tplDescriptor = _.template(fs.readFileSync(path.join(__dirname,'./templates/descriptor.tpl'),'utf8'));

/*
Constructor
*/
function DialProxy(config){

    /* Call the super constructor */
	MSFPlugin.apply(this,arguments);

    /* Route handlers */
	this.app.get(URI_ROOT, this.descriptor.bind(this));
    this.app.get(URI_ROOT + ':runTitle', this.proxy.bind(this));
    this.app.post(URI_ROOT + ':runTitle', this.proxy.bind(this));
    this.app.delete(URI_ROOT + ':runTitle/run', this.proxy.bind(this));
    this.app.post(URI_ROOT + ':runTitle/install',this.proxy.bind(this));
}

/*
 Extend the MSF Plugin
 */
MSFPlugin.extend(DialProxy);


/*
 Proxies all DIAL related request to the real DIAL endpoint
 */
DialProxy.prototype.proxy = function(req, res){

	var oUrl = url.parse(req.url);
	var dialUrl = 'http://127.0.0.1:' + PORT + oUrl.path;

	this.logger.debug('proxy request to', dialUrl);

	var proxyOptions = {
		uri: dialUrl,
		method: req.method,
		timeout: 20000,
		followRedirect: true,
		maxRedirects: 3,
		headers: req.headers
	};

	if (req.body.length > 0) proxyOptions = _.extend(proxyOptions, {body: req.body});

	request(proxyOptions, function(error, response, body) {
		if (response){
			res.send(response.statusCode,body);
		} else {
			this.logger.error(error.message);
			res.send(500, error.message);
		}

	}.bind(this));
};


/*
 Renders the UPNP Dial service descriptor
 */
DialProxy.prototype.descriptor = function(req, res, next){
	this.logger.debug('Dial Descriptor requested');
	try {
		res.set('Content-Type', 'application/xml');
		res.set("Application-URL", 'http://' + req.get('host') + this.service.port + URI_ROOT);
		res.end(tplDescriptor({
			service : this.service.config.service,
			device  : this.service.device.attributes
		}));
	} catch (e){
		this.logger.error(e.message);
		res.send(500, e.message);
	}
};

module.exports = DialProxy;