/*
 *  Copyright 2013 Samsung Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var minetypes = {
  "css": "text/css",
  "gif": "image/gif",
  "html": "text/html",
  "ico": "image/x-icon",
  "jpeg": "image/jpeg",
  "jpg": "image/jpeg",
  "js": "text/javascript",
  "json": "application/json",
  "pdf": "application/pdf",
  "png": "image/png",
  "svg": "image/svg+xml",
  "swf": "application/x-shockwave-flash",
  "tiff": "image/tiff",
  "txt": "text/plain",
  "wav": "audio/x-wav",
  "wma": "audio/x-ms-wma",
  "wmv": "video/x-ms-wmv",
  "xml": "text/xml"
};

var http = require('http');
var url=require('url');
var fs=require('fs');
var path=require('path');
var PORT = 5103;
var net = require('net');

function connListener(request, response) {
    var pathname = url.parse(request.url).pathname;
    var realPath = path.join(process.cwd()+ "/appLauncher/app", pathname);
    var ext = path.extname(realPath);
    ext = ext ? ext.slice(1) : 'unknown';
    fs.exists(realPath, function (exists) {
        if (!exists) {
            response.writeHead(404, {
                'Content-Type': 'text/plain'
            });

            response.write("This request URL " + realPath + " was not found on this server.");
			
            response.end();
        } else {
            fs.readFile(realPath, "binary", function (err, file) {
                if (err) {
                    response.writeHead(500, {
                        'Content-Type': 'text/plain'
                    });
                    response.end(err);
                } else {
                    var contentType = minetypes[ext] || "text/plain";
                    response.writeHead(200, {
                        'Content-Type': contentType
                    });
                    response.write(file, "binary");
                    response.end();
                }
            });
        }
    });

}

// check port is used or not
function probe(port, callback) {

    var server = net.createServer().listen(port);

    var calledOnce = false;

    var timeoutRef = setTimeout(function () {
        calledOnce = true;
        callback(false, port);
    }, 2000);

    timeoutRef.unref();

    var connected = false;

    server.on('listening', function() {
        clearTimeout(timeoutRef);

        if (server)
            server.close();

        if (!calledOnce) {
            calledOnce = true;
            callback(true, port);
        }
    });

    server.on('error', function(err) {
        clearTimeout(timeoutRef);

        var result = true;
        if (err.code === 'EADDRINUSE')
            result = false;

        if (!calledOnce) {
            calledOnce = true;
            callback(result, port);
        }
    });
}



function server(_port){
    probe(_port,function(bl,_pt){
        // bl = false: port is used
        // _pt: port
        if(bl === true){
            server = http.createServer(connListener);
            server = server.listen(parseInt(_pt, 10));

			var output = require('fs').createWriteStream('./naclport.txt');	
			output.write(String(_pt));
			
            console.log('Static file server running at => http://localhost : ' + _pt + '');
        }else{
            server(_pt + 1);
        }
    });
}

server(PORT);


