/*
 *  Copyright 2013 Samsung Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var http = require('http'),
    express = require('express'),
    util = require('util'),
    path = require('path'),
    //mime = require('express-custom-mime-types'),
    home = process.env[(process.platform == 'win32') ? 'USERPROFILE' : 'HOME'];

var self = {
	hls: function HTTPHLSServer(){
	    console.log('Starting HTTP HLS Server');

	    var app = express();
	   // app.use(mime({
	   //	    mimes: {'m3u8': 'application/x-mpegURL'}
	   //	}));

	    app.use(function(req, res, next){
		if (!req.is('text/plain')) {
		    return next();
		}
		req.body = '';
		req.on('data', function(data) {
		    return req.body += data;
		});
		return req.on('end', next);
	    });

	    // Parses the body of all other request types
	    app.use(express.bodyParser());
	    app.use(express.urlencoded());

	    // Ensures all request are good for cross domain
	    app.all('*', function(req, res, next) {
		res.header("Access-Control-Allow-Origin", "*");
		res.header("Access-Control-Allow-Credentials", true);
		res.header('Access-Control-Allow-Methods', 'GET,PUT,POST,DELETE');
		res.header("Access-Control-Allow-Headers", 'Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, SilentLaunch');
		next();
	    });

	    // Set proper options response for cross domain request
	    app.options('*', function(req, res) {
		res.header("Access-Control-Allow-Origin", "*");
		res.header("Access-Control-Allow-Credentials", true);
		res.header('Access-Control-Allow-Methods', 'GET,PUT,POST,DELETE');
		res.header("Access-Control-Allow-Headers", 'Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, SilentLaunch');
		res.send('HTTP HLS Server');
	    });

	    // Set app and hls root
	    app.use("/apps", express.static(home + '/root/apps'));
	    app.use("/apps/*", express.static(home + '/root/apps'));
	    app.use("/hls", express.static(home + '/hls'));
	    app.use("/hls/*", express.static(home + '/hls'));

            // Set ts liverstream and assets
	    app.use("/livestream/", express.static(path.join(__dirname, 'assets/livestream')));
	    app.use("/livestream/*", express.static(path.join(__dirname, 'assets/livestream')));
            app.use("/player/", express.static(path.join(__dirname, 'assets/player')));
            app.use("/player/*", express.static(path.join(__dirname, 'assets/player')));
            // console.log(path.join(__dirname, 'assets/player'));

	    app.get('/', function(req, res){
		res.send('web simulator 1.0');
	    });

	    this.server = http.createServer(app);
	    this.server.listen(3000);

	    console.log('HTTP HLS Service Started on port: 3000');
	}
};

module.exports = self;
