path = require 'path'

module.exports = (options = { }) ->
  return (req, res, next) ->
    if not options? or not options.mimes?
      next()
      return

    mimeType = options.mimes[path.extname(req.path)]
    if typeof mimeType is 'string'
      res.header('Content-Type', mimeType)
      return res.sendfile(
        path.resolve options.src, req.path.slice(1, req.path.length)
      )

    next()
