var fs = require('fs');
var path = require('path');
var uuid = require("node-uuid");
var logger = require('../logging/index').createNamedLogger('Utils');

var pincode = null;

function generateDeviceId(){

    var id = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    for( var i=0; i < 13; i++ ){
        id += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return id;
}

function generateUdn(){
    return uuid.v1();
}

function getInternalAddresses(){

    var os = require('os');
    var interfaces = os.networkInterfaces();
    var addresses = [];
    for (var k in interfaces) {
        for (var k2 in interfaces[k]) {
            var address = interfaces[k][k2];
            if (address.family === 'IPv4' && !address.internal) {
                addresses.push(address.address);
            }
        }
    }
    return addresses;
}

function getInternalIP(){
    var addresses = getInternalAddresses();
    return addresses[0];
}


function isInternalIp(ip){
    var addresses = getInternalAddresses();
    addresses.push('127.0.0.1');
    logger.debug('isInternalIp('+ip+') verifying from addresses ', addresses);
    return (addresses.indexOf(ip) > -1);
}

function getPinCode() {
	if (!pincode){
        var code = "";
        for(var i = 0; i < 6; i++) {
            code+= Math.round(Math.random() * 9);
        }
		//var ts = new Date();
		//pincode = {"code":ts.getTime().toString().substr(-6), "ttl":180, "type": "local"};
        pincode = {"code":code.toString(), "ttl":180, "type": "local"};
		setTimeout(function(){
			pincode = null;
		}, pincode.ttl*1000);
		return pincode;
	} else {
		return pincode;
	}
}

exports.getInternalIP = getInternalIP;
exports.isInternalIp = isInternalIp;
exports.getPinCode = getPinCode;
exports.generateDeviceId = generateDeviceId;
exports.generateUdn = generateUdn;
