var _ = require('lodash');
var util = require('util');
var request = require('request');
var MSFPlugin = require('../plugin');

/*
 Constants
 */
var URI_SERVICE = 'http://multiscreen.samsung.com/discovery/reservations';


function CloudDiscoveryV1(config){

	/*
    Call the BaseModule constructor
	 */
    MSFPlugin.apply(this, arguments);

    /*
     Device event handlers
     */
    this.device.on('change',this.update.bind(this));
    this.device.on('ready', this.update.bind(this));

    /*
     LEGACY : Add this method dynamically to support the V1 API method
     */
    this.device.getCloudPinCode = this.getCloudPinCode.bind(this);
}

MSFPlugin.extend(CloudDiscoveryV1);


/*
 Regenerates and updates the services reservation in the cloud
 */
CloudDiscoveryV1.prototype.update = function(){

    var device  = this.device;

    // TODO : Move these string values to constants or derive from request
    var reservation = {
        "DUID": device.attributes.duid,
        "Model": device.attributes.model,
        "IP": device.attributes.ip,
        "ServiceURI": "http://"+this.utils.getInternalIP()+":8001/ms/1.0/",
        "DialURI": "http://"+this.utils.getInternalIP()+":8001/ws/apps/",
        "NetworkType": device.attributes.networkType,
        "SSID": device.attributes.ssid,
        "FirmwareVersion": device.attributes.firmwareVersion,
        "CountryCode": device.attributes.countryCode,
        "DeviceName": device.attributes.name,
        "DeviceID": device.attributes.id,
        "ModelDescription": device.attributes.model,
        "ModelName": device.attributes.modelName,
        "UDN": device.attributes.udn,
        "Resolution": device.attributes.resolution,
        "Capabilities": [{
            name : "samsung:multiscreen:1",
            port : "8001",
            location : "/ms/1.0/"
        }]

    };

    this.logger.info('updating reservation to : ', reservation);

	request.post(URI_SERVICE, {json : reservation}, function(error, response, body){
        if(error){
            this.logger.error(error);
        }else if(response.statusCode !== 200){
            this.logger.warn('update response : http error status of '+response.statusCode);
        }else if(!body || !body.ttl){
            this.logger.warn('update response : no ttl in response ', response.body);
        }else{
            this.logger.info('update response : ', response.body);
            var nextUpdate = (response.body.ttl/2) * 1000;
            setTimeout(this.update.bind(this), nextUpdate);
        }

    }.bind(this));
};

CloudDiscoveryV1.prototype.getCloudPinCode = function(options,cb){

    this.logger.info('retrieving cloud pincode');

    var self = this;

    request.get(URI_SERVICE + '/' + self.device.attributes.duid + '/code', function(error, response, body){

        try{
            body = JSON.parse(body);
        } catch (e){
            if(!error){
                error = e;
            }
        }

        if(error || response.statusCode !== 200 || !body || !body.ttl || !body.code){
            self.logger.warn('invalid pincode response', body);
            cb(error, null);
        }else{
            self.logger.info('received pincode : ', body.code);
            self.pincode = {code:body.code, ttl: body.ttl, type:'cloud'};

            cb(null, self.pincode);
        }
    });

};

module.exports = CloudDiscoveryV1;
