#!/usr/bin/env
# -*- coding: UTF-8 -*-
# vim: sw=4 ts=4 expandtab ai
#
# Copyright (c) 2013 Intel, Inc.
# License: GPLv2
# Author: Alexander Kanevskiy <alexander.kanevskiy@intel.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.


"""
change-abandoned hook entry module
"""

import sys
import argparse

from gerrithooks.common import run_plugin_hooks

def parse_cmdline(argv):
    """Parse hook command line parameters."""
    parser = argparse.ArgumentParser(
        description="Gerrit change-abandoned hook")
    args = (
            "--change",     # <change id>
            "--change-url", # <change url>
            "--project",    # <project name>
            "--branch",     # <branch>
            "--topic",      # <topic>
            "--abandoner",  # <abandoner>
            "--reason",     # <reason>
            "--change-owner",
            "--change-owner-username",
            "--abandoner-username",
            "--commit"
        )
    for arg in args:
        parser.add_argument(arg)
    parser.add_argument("-d", "--debug", action="store_true")
    return parser.parse_args(argv)


def main():
    """ change-abandoned hook entry """

    return run_plugin_hooks("change-abandoned", parse_cmdline)

if __name__ == "__main__":
    sys.exit(main())
