#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# vim: sw=4 ts=4 expandtab ai

import os
from setuptools import setup, find_packages

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup (
    name = "gerrithooks",
    version = "0.1.1",
    packages = find_packages(),
    license = "GPLv2",
    description = "Collection of useful hooks for Gerrit",
    long_description = README,
    # url = "http://",
    include_package_data = True,
    zip_safe = [True, False][bool(os.getenv('VIRTUAL_ENV'))],
    data_files = [
        (['/etc/gerrithooks', 'gerrithooks'][bool(os.getenv('VIRTUAL_ENV'))],
                ["gerrithooks.conf", "gerrithooks-log.conf"])
        ],
    author = "Alexander Kanevskiy",
    author_email = "alexander.kanevskiy@intel.com",
    keywords = "gerrit hooks",
    platforms="Python 2.7",
    entry_points={
            'console_scripts': [
                'gerrit-change-abandoned = gerrithooks.change_abandoned:main',
                'gerrit-change-merged = gerrithooks.change_merged:main',
                'gerrit-change-restored = gerrithooks.change_restored:main',
                'gerrit-cla-signed = gerrithooks.cla_signed:main',
                'gerrit-comment-added = gerrithooks.comment_added:main',
                'gerrit-draft-published = gerrithooks.draft_published:main',
                'gerrit-merge-failed = gerrithooks.merge_failed:main',
                'gerrit-patchset-created = gerrithooks.patchset_created:main',
                'gerrit-ref-update = gerrithooks.ref_update:main',
                'gerrit-ref-updated = gerrithooks.ref_updated:main',
                'gerrit-reviewer-added = gerrithooks.reviewer_added:main'
            ]
        },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Console",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: POSIX :: Linux",
        "Operating System :: MacOS :: MacOS X",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Version Control",
        "Topic :: System :: Systems Administration",
        "Topic :: Utilities",
        ]
    )

