#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# vim: sw=4 ts=4 expandtab ai

import os
from setuptools import setup, find_packages

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup (
    name = "gerritrest",
    version = "0.1.2",
    packages = ['gerritrest'],
    # include_package_data=True,
    license = "GPLv2",
    description = "Access to Gerrit 2.6+ REST APIs",
    long_description = README,
    # url = "http://",
    author = "Alexander Kanevskiy",
    author_email = "alexander.kanevskiy@intel.com",
    keywords = "python gerrit REST api",
    platforms="Python 2.6 and later.",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Web Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        'Topic :: Internet :: WWW/HTTP',
        "Topic :: Software Development :: Libraries :: Python Modules"
        ]
    )

